/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.mapreduce;

import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class TransposeMapper
extends Mapper<IntWritable, VectorWritable, IntWritable, VectorWritable> {
    public static final String NEW_NUM_COLS_PARAM = TransposeMapper.class.getName() + ".newNumCols";
    private int newNumCols;

    protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
        this.newNumCols = ctx.getConfiguration().getInt(NEW_NUM_COLS_PARAM, Integer.MAX_VALUE);
    }

    protected void map(IntWritable r, VectorWritable v, Mapper.Context ctx) throws IOException, InterruptedException {
        int row = r.get();
        for (Vector.Element e : v.get().nonZeroes()) {
            RandomAccessSparseVector tmp = new RandomAccessSparseVector(this.newNumCols, 1);
            tmp.setQuick(row, e.get());
            r.set(e.index());
            ctx.write((Object)r, (Object)new VectorWritable((Vector)tmp));
        }
    }
}

