/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.vectorizer.encoders.ContinuousValueEncoder;
import org.apache.mahout.vectorizer.encoders.FeatureVectorEncoder;
import org.apache.mahout.vectorizer.encoders.InteractionValueEncoder;
import org.apache.mahout.vectorizer.encoders.StaticWordValueEncoder;
import org.apache.mahout.vectorizer.encoders.TextValueEncoder;
import org.junit.Test;

public class InteractionValueEncoderTest
extends MahoutTestCase {
    @Test
    public void testAddToVector() {
        StaticWordValueEncoder wv = new StaticWordValueEncoder("word");
        ContinuousValueEncoder cv = new ContinuousValueEncoder("cont");
        InteractionValueEncoder enc = new InteractionValueEncoder("interactions", (FeatureVectorEncoder)wv, (FeatureVectorEncoder)cv);
        DenseVector v1 = new DenseVector(200);
        enc.addInteractionToVector("a", "1.0", 1.0, (Vector)v1);
        int k = enc.getProbes();
        InteractionValueEncoderTest.assertEquals((double)k, (double)v1.norm(1.0), (double)0.0);
        InteractionValueEncoderTest.assertEquals((double)1.0, (double)v1.maxValue(), (double)0.0);
        enc.addInteractionToVector("a", "1.0", 1.0, (Vector)v1);
        InteractionValueEncoderTest.assertEquals((double)((float)k * 2.0f), (double)v1.norm(1.0), (double)0.0);
        InteractionValueEncoderTest.assertEquals((double)2.0, (double)v1.maxValue(), (double)0.0);
        DenseVector v2 = new DenseVector(20000);
        enc.addInteractionToVector("a", "1.0", 1.0, (Vector)v2);
        wv.addToVector("a", (Vector)v2);
        cv.addToVector("1.0", (Vector)v2);
        k = enc.getProbes();
        InteractionValueEncoderTest.assertEquals((double)(k + wv.getProbes() + cv.getProbes()), (double)v2.norm(1.0), (double)0.001);
    }

    @Test
    public void testAddToVectorUsesProductOfWeights() {
        StaticWordValueEncoder wv = new StaticWordValueEncoder("word");
        ContinuousValueEncoder cv = new ContinuousValueEncoder("cont");
        InteractionValueEncoder enc = new InteractionValueEncoder("interactions", (FeatureVectorEncoder)wv, (FeatureVectorEncoder)cv);
        DenseVector v1 = new DenseVector(200);
        enc.addInteractionToVector("a", "0.9", 0.5, (Vector)v1);
        int k = enc.getProbes();
        InteractionValueEncoderTest.assertEquals((double)((double)k * 0.5 * 0.9), (double)v1.norm(1.0), (double)0.0);
        InteractionValueEncoderTest.assertEquals((double)0.45, (double)v1.maxValue(), (double)0.0);
    }

    @Test
    public void testAddToVectorWithTextValueEncoder() {
        StaticWordValueEncoder wv = new StaticWordValueEncoder("word");
        TextValueEncoder tv = new TextValueEncoder("text");
        InteractionValueEncoder enc = new InteractionValueEncoder("interactions", (FeatureVectorEncoder)wv, (FeatureVectorEncoder)tv);
        DenseVector v1 = new DenseVector(200);
        enc.addInteractionToVector("a", "some text here", 1.0, (Vector)v1);
        int k = enc.getProbes();
        InteractionValueEncoderTest.assertEquals((double)((float)k * 3.0f), (double)v1.norm(1.0), (double)0.0);
    }

    @Test
    public void testTraceDictionary() {
        StaticWordValueEncoder encoder1 = new StaticWordValueEncoder("first");
        StaticWordValueEncoder encoder2 = new StaticWordValueEncoder("second");
        HashMap traceDictionary = Maps.newHashMap();
        InteractionValueEncoder interactions = new InteractionValueEncoder("interactions", (FeatureVectorEncoder)encoder1, (FeatureVectorEncoder)encoder2);
        interactions.setProbes(1);
        interactions.setTraceDictionary((Map)traceDictionary);
        DenseVector v = new DenseVector(10);
        interactions.addInteractionToVector("a", "b", 1.0, (Vector)v);
        InteractionValueEncoderTest.assertEquals((long)1L, (long)v.getNumNonZeroElements());
        InteractionValueEncoderTest.assertEquals((long)1L, (long)traceDictionary.size());
        InteractionValueEncoderTest.assertEquals((Object)"interactions=a:b", (Object)Iterables.getFirst(traceDictionary.keySet(), null));
    }
}

