/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.stats;

import java.util.Random;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.stats.Sampler;
import org.junit.Test;

public class SamplerTest
extends MahoutTestCase {
    @Test
    public void testDiscreteSampler() {
        DenseVector distribution = new DenseVector(new double[]{1.0, 0.0, 2.0, 3.0, 5.0, 0.0});
        Sampler sampler = new Sampler((Random)RandomUtils.getRandom(), (Vector)distribution);
        Vector sampledDistribution = distribution.like();
        for (int i = 0; i < 100000; ++i) {
            int index = sampler.sample();
            sampledDistribution.set(index, sampledDistribution.get(index) + 1.0);
        }
        SamplerTest.assertTrue((String)"sampled distribution is far from the original", (SamplerTest.l1Dist((Vector)distribution, sampledDistribution) < 0.01 ? 1 : 0) != 0);
    }

    private static double l1Dist(Vector v, Vector w) {
        return v.normalize(1.0).minus(w.normalize(1.0)).norm(1.0);
    }
}

