/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.neighborhood;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.EuclideanDistanceMeasure;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixSlice;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.neighborhood.FastProjectionSearch;
import org.apache.mahout.math.neighborhood.LocalitySensitiveHashSearch;
import org.apache.mahout.math.neighborhood.ProjectionSearch;
import org.apache.mahout.math.neighborhood.UpdatableSearcher;
import org.apache.mahout.math.random.MultiNormal;
import org.apache.mahout.math.random.WeightedThing;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SearchSanityTest
extends MahoutTestCase {
    private static final int NUM_DATA_POINTS = 8192;
    private static final int NUM_DIMENSIONS = 20;
    private static final int NUM_PROJECTIONS = 3;
    private static final int SEARCH_SIZE = 30;
    private UpdatableSearcher searcher;
    private Matrix dataPoints;

    protected static Matrix multiNormalRandomData(int numDataPoints, int numDimensions) {
        DenseMatrix data = new DenseMatrix(numDataPoints, numDimensions);
        MultiNormal gen = new MultiNormal(20);
        for (MatrixSlice slice : data) {
            slice.vector().assign(gen.sample());
        }
        return data;
    }

    @Parameterized.Parameters
    public static List<Object[]> generateData() {
        RandomUtils.useTestSeed();
        Matrix dataPoints = SearchSanityTest.multiNormalRandomData(8192, 20);
        return Arrays.asList({new ProjectionSearch((DistanceMeasure)new EuclideanDistanceMeasure(), 3, 30), dataPoints}, {new FastProjectionSearch((DistanceMeasure)new EuclideanDistanceMeasure(), 3, 30), dataPoints}, {new LocalitySensitiveHashSearch((DistanceMeasure)new EuclideanDistanceMeasure(), 30), dataPoints});
    }

    public SearchSanityTest(UpdatableSearcher searcher, Matrix dataPoints) {
        this.searcher = searcher;
        this.dataPoints = dataPoints;
    }

    @Test
    public void testExactMatch() {
        this.searcher.clear();
        Matrix data = this.dataPoints;
        Iterable batch1 = Iterables.limit((Iterable)data, (int)300);
        ArrayList queries = Lists.newArrayList((Iterable)Iterables.limit((Iterable)batch1, (int)100));
        this.searcher.addAllMatrixSlices(batch1);
        SearchSanityTest.assertEquals((long)300L, (long)this.searcher.size());
        Vector q = ((MatrixSlice)Iterables.get((Iterable)data, (int)0)).vector();
        List r = this.searcher.search(q, 2);
        SearchSanityTest.assertEquals((double)0.0, (double)((Vector)((WeightedThing)r.get(0)).getValue()).minus(q).norm(1.0), (double)1.0E-8);
        Iterable batch2 = Iterables.limit((Iterable)Iterables.skip((Iterable)data, (int)300), (int)10);
        this.searcher.addAllMatrixSlices(batch2);
        SearchSanityTest.assertEquals((long)310L, (long)this.searcher.size());
        q = ((MatrixSlice)Iterables.get((Iterable)data, (int)302)).vector();
        r = this.searcher.search(q, 2);
        SearchSanityTest.assertEquals((double)0.0, (double)((Vector)((WeightedThing)r.get(0)).getValue()).minus(q).norm(1.0), (double)1.0E-8);
        this.searcher.addAllMatrixSlices(Iterables.skip((Iterable)data, (int)310));
        SearchSanityTest.assertEquals((long)this.dataPoints.numRows(), (long)this.searcher.size());
        for (MatrixSlice query : queries) {
            r = this.searcher.search(query.vector(), 2);
            SearchSanityTest.assertEquals((String)"Distance has to be about zero", (double)0.0, (double)((WeightedThing)r.get(0)).getWeight(), (double)1.0E-6);
            SearchSanityTest.assertEquals((String)"Answer must be substantially the same as query", (double)0.0, (double)((Vector)((WeightedThing)r.get(0)).getValue()).minus(query.vector()).norm(1.0), (double)1.0E-8);
            SearchSanityTest.assertTrue((String)"Wrong answer must have non-zero distance", (((WeightedThing)r.get(1)).getWeight() > ((WeightedThing)r.get(0)).getWeight() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNearMatch() {
        this.searcher.clear();
        ArrayList queries = Lists.newArrayList((Iterable)Iterables.limit((Iterable)this.dataPoints, (int)100));
        this.searcher.addAllMatrixSlicesAsWeightedVectors((Iterable)this.dataPoints);
        MultiNormal noise = new MultiNormal(0.01, (Vector)new DenseVector(20));
        for (MatrixSlice slice : queries) {
            Vector query = slice.vector();
            Vector epsilon = noise.sample();
            List r = this.searcher.search(query, 2);
            query = query.plus(epsilon);
            SearchSanityTest.assertEquals((String)"Distance has to be small", (double)epsilon.norm(2.0), (double)((WeightedThing)r.get(0)).getWeight(), (double)0.1);
            SearchSanityTest.assertEquals((String)"Answer must be substantially the same as query", (double)epsilon.norm(2.0), (double)((Vector)((WeightedThing)r.get(0)).getValue()).minus(query).norm(2.0), (double)0.1);
            SearchSanityTest.assertTrue((String)"Wrong answer must be further away", (((WeightedThing)r.get(1)).getWeight() > ((WeightedThing)r.get(0)).getWeight() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOrdering() {
        this.searcher.clear();
        DenseMatrix queries = new DenseMatrix(100, 20);
        MultiNormal gen = new MultiNormal(20);
        for (int i = 0; i < 100; ++i) {
            queries.viewRow(i).assign(gen.sample());
        }
        this.searcher.addAllMatrixSlices((Iterable)this.dataPoints);
        for (MatrixSlice query : queries) {
            List r = this.searcher.search(query.vector(), 200);
            double x = 0.0;
            for (WeightedThing thing : r) {
                SearchSanityTest.assertTrue((String)"Scores must be monotonic increasing", (thing.getWeight() >= x ? 1 : 0) != 0);
                x = thing.getWeight();
            }
        }
    }

    @Test
    public void testRemoval() {
        this.searcher.clear();
        this.searcher.addAllMatrixSlices((Iterable)this.dataPoints);
        if (this.searcher instanceof UpdatableSearcher) {
            ArrayList x = Lists.newArrayList((Iterable)Iterables.limit((Iterable)this.searcher, (int)2));
            int size0 = this.searcher.size();
            List r0 = this.searcher.search((Vector)x.get(0), 2);
            this.searcher.remove((Vector)x.get(0), 1.0E-7);
            SearchSanityTest.assertEquals((long)(size0 - 1), (long)this.searcher.size());
            List r = this.searcher.search((Vector)x.get(0), 1);
            SearchSanityTest.assertTrue((String)"Vector should be gone", (((WeightedThing)r.get(0)).getWeight() > 0.0 ? 1 : 0) != 0);
            SearchSanityTest.assertEquals((String)"Previous second neighbor should be first", (double)0.0, (double)((Vector)((WeightedThing)r.get(0)).getValue()).minus((Vector)((WeightedThing)r0.get(1)).getValue()).norm(1.0), (double)1.0E-8);
            this.searcher.remove((Vector)x.get(1), 1.0E-7);
            SearchSanityTest.assertEquals((long)(size0 - 2), (long)this.searcher.size());
            r = this.searcher.search((Vector)x.get(1), 1);
            SearchSanityTest.assertTrue((String)"Vector should be gone", (((WeightedThing)r.get(0)).getWeight() > 0.0 ? 1 : 0) != 0);
            for (Vector v : this.searcher) {
                SearchSanityTest.assertTrue((((Vector)x.get(0)).minus(v).norm(1.0) > 1.0E-6 ? 1 : 0) != 0);
                SearchSanityTest.assertTrue((((Vector)x.get(1)).minus(v).norm(1.0) > 1.0E-6 ? 1 : 0) != 0);
            }
        } else {
            try {
                ArrayList x = Lists.newArrayList((Iterable)Iterables.limit((Iterable)this.searcher, (int)2));
                this.searcher.remove((Vector)x.get(0), 1.0E-7);
                SearchSanityTest.fail((String)("Shouldn't be able to delete from " + this.searcher.getClass().getName()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testSearchFirst() {
        this.searcher.clear();
        this.searcher.addAll((Iterable)this.dataPoints);
        for (Vector datapoint : this.dataPoints) {
            WeightedThing first = this.searcher.searchFirst(datapoint, false);
            WeightedThing second = this.searcher.searchFirst(datapoint, true);
            List firstTwo = this.searcher.search(datapoint, 2);
            SearchSanityTest.assertEquals((String)"First isn't self", (double)0.0, (double)first.getWeight(), (double)0.0);
            SearchSanityTest.assertEquals((String)"First isn't self", (Object)datapoint, (Object)first.getValue());
            SearchSanityTest.assertEquals((String)"First doesn't match", (Object)first, firstTwo.get(0));
            SearchSanityTest.assertEquals((String)"Second doesn't match", (Object)second, firstTwo.get(1));
        }
    }

    @Test
    public void testSearchLimiting() {
        this.searcher.clear();
        this.searcher.addAll((Iterable)this.dataPoints);
        for (Vector datapoint : this.dataPoints) {
            List firstTwo = this.searcher.search(datapoint, 2);
            SearchSanityTest.assertThat((String)"Search limit isn't respected", (Object)firstTwo.size(), (Matcher)Matchers.is((Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(2))));
        }
    }

    @Test
    public void testRemove() {
        this.searcher.clear();
        for (int i = 0; i < this.dataPoints.rowSize(); ++i) {
            Vector datapoint = this.dataPoints.viewRow(i);
            this.searcher.add(datapoint);
            if (i % 2 != 0) continue;
            SearchSanityTest.assertTrue((String)"Failed to find self [search]", (((WeightedThing)this.searcher.search(datapoint, 1).get(0)).getWeight() < 1.0E-6 ? 1 : 0) != 0);
            SearchSanityTest.assertTrue((String)"Failed to find self [searchFirst]", (this.searcher.searchFirst(datapoint, false).getWeight() < 1.0E-6 ? 1 : 0) != 0);
            SearchSanityTest.assertTrue((String)"Failed to remove self", (boolean)this.searcher.remove(datapoint, 1.0E-6));
        }
    }
}

