/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.SingularValueDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDCommonTest;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDHelper;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDSolver;
import org.junit.Test;

public class LocalSSVDSolverSparseSequentialTest
extends MahoutTestCase {
    private static final double s_epsilon = 1.0E-10;

    @Test
    public void testSSVDSolverPowerIterations1() throws IOException {
        this.runSSVDSolver(1);
    }

    public void runSSVDSolver(int q) throws IOException {
        Configuration conf = this.getConfiguration();
        conf.set("mapred.job.tracker", "local");
        conf.set("fs.default.name", "file:///");
        LinkedList closeables = Lists.newLinkedList();
        RandomWrapper rnd = RandomUtils.getRandom();
        File tmpDir = this.getTestTempDir("svdtmp");
        conf.set("hadoop.tmp.dir", tmpDir.getAbsolutePath());
        Path aLocPath = new Path(this.getTestTempDirPath("svdtmp/A"), "A.seq");
        SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)FileSystem.getLocal((Configuration)conf), (Configuration)conf, (Path)aLocPath, IntWritable.class, VectorWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)new DefaultCodec());
        closeables.addFirst(w);
        int n = 100;
        int m = 2000;
        double percent = 5.0;
        VectorWritable vw = new VectorWritable();
        IntWritable roww = new IntWritable();
        double muAmplitude = 50.0;
        for (int i = 0; i < m; ++i) {
            SequentialAccessSparseVector dv = new SequentialAccessSparseVector(n);
            int j = 0;
            while ((double)j < (double)n * percent / 100.0) {
                dv.setQuick(rnd.nextInt(n), muAmplitude * (rnd.nextDouble() - 0.5));
                ++j;
            }
            roww.set(i);
            vw.set((Vector)dv);
            w.append((Writable)roww, (Writable)vw);
        }
        closeables.remove(w);
        Closeables.close((Closeable)w, (boolean)false);
        FileSystem fs = FileSystem.get((URI)aLocPath.toUri(), (Configuration)conf);
        Path tempDirPath = this.getTestTempDirPath("svd-proc");
        Path aPath = new Path(tempDirPath, "A/A.seq");
        fs.copyFromLocalFile(aLocPath, aPath);
        Path svdOutPath = new Path(tempDirPath, "SSVD-out");
        fs.delete(svdOutPath, true);
        System.out.println("Input prepared, starting solver...");
        int ablockRows = 867;
        int p = 60;
        int k = 40;
        SSVDSolver ssvd = new SSVDSolver(conf, new Path[]{aPath}, svdOutPath, ablockRows, k, p, 3);
        ssvd.setOuterBlockHeight(500);
        ssvd.setAbtBlockHeight(251);
        ssvd.setComputeU(false);
        ssvd.setComputeV(false);
        ssvd.setOverwrite(true);
        ssvd.setQ(q);
        ssvd.setBroadcast(true);
        ssvd.run();
        Vector stochasticSValues = ssvd.getSingularValues();
        System.out.println("--SSVD solver singular values:");
        LocalSSVDSolverSparseSequentialTest.dumpSv(stochasticSValues);
        System.out.println("--Colt SVD solver singular values:");
        DenseMatrix a = SSVDHelper.drmLoadAsDense((FileSystem)fs, (Path)aPath, (Configuration)conf);
        SingularValueDecomposition svd2 = new SingularValueDecomposition((Matrix)a);
        DenseVector svalues2 = new DenseVector(svd2.getSingularValues());
        LocalSSVDSolverSparseSequentialTest.dumpSv((Vector)svalues2);
        for (int i = 0; i < k + p; ++i) {
            LocalSSVDSolverSparseSequentialTest.assertTrue((Math.abs(svalues2.getQuick(i) - stochasticSValues.getQuick(i)) <= 1.0E-10 ? 1 : 0) != 0);
        }
        DenseMatrix mQ = SSVDHelper.drmLoadAsDense((FileSystem)fs, (Path)new Path(svdOutPath, "Bt-job/Q-*"), (Configuration)conf);
        SSVDCommonTest.assertOrthonormality((Matrix)mQ, false, 1.0E-10);
        IOUtils.close((Collection)closeables);
    }

    static void dumpSv(Vector s) {
        System.out.printf("svs: ", new Object[0]);
        for (Vector.Element el : s.all()) {
            System.out.printf("%f  ", el.get());
        }
        System.out.println();
    }

    static void dump(double[][] matrix) {
        double[][] arr$ = matrix;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] aMatrix;
            for (double anAMatrix : aMatrix = arr$[i$]) {
                System.out.printf("%f  ", anAMatrix);
            }
            System.out.println();
        }
    }
}

