/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.distance.CosineDistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public final class CosineDistanceMeasureTest
extends MahoutTestCase {
    @Test
    public void testMeasure() {
        CosineDistanceMeasure distanceMeasure = new CosineDistanceMeasure();
        Vector[] vectors = new Vector[]{new DenseVector(new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 0.0}), new DenseVector(new double[]{1.0, 1.0, 1.0, 0.0, 0.0, 0.0}), new DenseVector(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0})};
        double[][] distanceMatrix = new double[3][3];
        for (int a = 0; a < 3; ++a) {
            for (int b = 0; b < 3; ++b) {
                distanceMatrix[a][b] = distanceMeasure.distance(vectors[a], vectors[b]);
            }
        }
        CosineDistanceMeasureTest.assertEquals((double)0.0, (double)distanceMatrix[0][0], (double)1.0E-6);
        CosineDistanceMeasureTest.assertTrue((distanceMatrix[0][0] < distanceMatrix[0][1] ? 1 : 0) != 0);
        CosineDistanceMeasureTest.assertTrue((distanceMatrix[0][1] < distanceMatrix[0][2] ? 1 : 0) != 0);
        CosineDistanceMeasureTest.assertEquals((double)0.0, (double)distanceMatrix[1][1], (double)1.0E-6);
        CosineDistanceMeasureTest.assertTrue((distanceMatrix[1][0] > distanceMatrix[1][1] ? 1 : 0) != 0);
        CosineDistanceMeasureTest.assertTrue((distanceMatrix[1][2] < distanceMatrix[1][0] ? 1 : 0) != 0);
        CosineDistanceMeasureTest.assertEquals((double)0.0, (double)distanceMatrix[2][2], (double)1.0E-6);
        CosineDistanceMeasureTest.assertTrue((distanceMatrix[2][0] > distanceMatrix[2][1] ? 1 : 0) != 0);
        CosineDistanceMeasureTest.assertTrue((distanceMatrix[2][1] > distanceMatrix[2][2] ? 1 : 0) != 0);
        CosineDistanceMeasureTest.assertEquals((double)0.0, (double)distanceMeasure.distance((Vector)new SequentialAccessSparseVector(1), (Vector)new SequentialAccessSparseVector(1)), (double)1.0E-6);
    }
}

