/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import java.io.File;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.MahoutTestCase;
import org.junit.Test;

public class DistributedCacheFileLocationTest
extends MahoutTestCase {
    static final File FILE_I_WANT_TO_FIND = new File("file/i_want_to_find.txt");
    static final URI[] DISTRIBUTED_CACHE_FILES = new URI[]{new File("/first/file").toURI(), new File("/second/file").toURI(), FILE_I_WANT_TO_FIND.toURI()};

    @Test
    public void nonExistingFile() {
        Path path = HadoopUtil.findInCacheByPartOfFilename((String)"no such file", (URI[])DISTRIBUTED_CACHE_FILES);
        DistributedCacheFileLocationTest.assertNull((Object)path);
    }

    @Test
    public void existingFile() {
        Path path = HadoopUtil.findInCacheByPartOfFilename((String)"want_to_find", (URI[])DISTRIBUTED_CACHE_FILES);
        DistributedCacheFileLocationTest.assertNotNull((Object)path);
        DistributedCacheFileLocationTest.assertEquals((Object)FILE_I_WANT_TO_FIND.getName(), (Object)path.getName());
    }
}

