/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.topdown;

import java.io.File;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.topdown.PathDirectory;
import org.apache.mahout.common.MahoutTestCase;
import org.junit.Test;

public final class PathDirectoryTest
extends MahoutTestCase {
    private final Path output = new Path("output");

    @Test
    public void shouldReturnTopLevelClusterPath() {
        Path expectedPath = new Path(this.output, "topLevelCluster");
        PathDirectoryTest.assertEquals((Object)expectedPath, (Object)PathDirectory.getTopLevelClusterPath((Path)this.output));
    }

    @Test
    public void shouldReturnClusterPostProcessorOutputDirectory() {
        Path expectedPath = new Path(this.output, "clusterPostProcessed");
        PathDirectoryTest.assertEquals((Object)expectedPath, (Object)PathDirectory.getClusterPostProcessorOutputDirectory((Path)this.output));
    }

    @Test
    public void shouldReturnClusterOutputClusteredPoints() {
        Path expectedPath = new Path(this.output, "clusteredPoints" + File.separator + '*');
        PathDirectoryTest.assertEquals((Object)expectedPath, (Object)PathDirectory.getClusterOutputClusteredPoints((Path)this.output));
    }

    @Test
    public void shouldReturnBottomLevelClusterPath() {
        Path expectedPath = new Path(this.output + File.separator + "bottomLevelCluster" + File.separator + '1');
        PathDirectoryTest.assertEquals((Object)expectedPath, (Object)PathDirectory.getBottomLevelClusterPath((Path)this.output, (String)"1"));
    }

    @Test
    public void shouldReturnClusterPathForClusterId() {
        Path expectedPath = new Path(PathDirectory.getClusterPostProcessorOutputDirectory((Path)this.output), new Path("1"));
        PathDirectoryTest.assertEquals((Object)expectedPath, (Object)PathDirectory.getClusterPathForClusterId((Path)PathDirectory.getClusterPostProcessorOutputDirectory((Path)this.output), (String)"1"));
    }
}

