/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import java.util.Arrays;
import java.util.List;
import org.apache.mahout.classifier.sequencelearning.hmm.HMMTestBase;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmUtils;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public class HMMUtilsTest
extends HMMTestBase {
    private Matrix legal22;
    private Matrix legal23;
    private Matrix legal33;
    private Vector legal2;
    private Matrix illegal22;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.legal22 = new DenseMatrix((double[][])new double[][]{{0.5, 0.5}, {0.3, 0.7}});
        this.legal23 = new DenseMatrix((double[][])new double[][]{{0.2, 0.2, 0.6}, {0.3, 0.3, 0.4}});
        this.legal33 = new DenseMatrix((double[][])new double[][]{{0.1, 0.1, 0.8}, {0.1, 0.2, 0.7}, {0.2, 0.3, 0.5}});
        this.legal2 = new DenseVector(new double[]{0.4, 0.6});
        this.illegal22 = new DenseMatrix((double[][])new double[][]{{1.0, 2.0}, {3.0, 4.0}});
    }

    @Test
    public void testValidatorLegal() {
        HmmUtils.validate((HmmModel)new HmmModel(this.legal22, this.legal23, this.legal2));
    }

    @Test
    public void testValidatorDimensionError() {
        try {
            HmmUtils.validate((HmmModel)new HmmModel(this.legal33, this.legal23, this.legal2));
        }
        catch (IllegalArgumentException e) {
            return;
        }
        HMMUtilsTest.fail();
    }

    @Test
    public void testValidatorIllegelMatrixError() {
        try {
            HmmUtils.validate((HmmModel)new HmmModel(this.illegal22, this.legal23, this.legal2));
        }
        catch (IllegalArgumentException e) {
            return;
        }
        HMMUtilsTest.fail();
    }

    @Test
    public void testEncodeStateSequence() {
        int i;
        String[] hiddenSequence = new String[]{"H1", "H2", "H0", "H3", "H4"};
        String[] outputSequence = new String[]{"O1", "O2", "O4", "O0"};
        int[] hiddenSequenceEnc = HmmUtils.encodeStateSequence((HmmModel)this.getModel(), Arrays.asList(hiddenSequence), (boolean)false, (int)-1);
        int[] outputSequenceEnc = HmmUtils.encodeStateSequence((HmmModel)this.getModel(), Arrays.asList(outputSequence), (boolean)true, (int)-1);
        int[] hiddenSequenceExp = new int[]{1, 2, 0, 3, -1};
        int[] outputSequenceExp = new int[]{1, 2, -1, 0};
        for (i = 0; i < hiddenSequenceEnc.length; ++i) {
            HMMUtilsTest.assertEquals((long)hiddenSequenceExp[i], (long)hiddenSequenceEnc[i]);
        }
        for (i = 0; i < outputSequenceEnc.length; ++i) {
            HMMUtilsTest.assertEquals((long)outputSequenceExp[i], (long)outputSequenceEnc[i]);
        }
    }

    @Test
    public void testDecodeStateSequence() {
        int i;
        int[] hiddenSequence = new int[]{1, 2, 0, 3, 10};
        int[] outputSequence = new int[]{1, 2, 10, 0};
        List hiddenSequenceDec = HmmUtils.decodeStateSequence((HmmModel)this.getModel(), (int[])hiddenSequence, (boolean)false, (String)"unknown");
        List outputSequenceDec = HmmUtils.decodeStateSequence((HmmModel)this.getModel(), (int[])outputSequence, (boolean)true, (String)"unknown");
        String[] hiddenSequenceExp = new String[]{"H1", "H2", "H0", "H3", "unknown"};
        String[] outputSequenceExp = new String[]{"O1", "O2", "unknown", "O0"};
        for (i = 0; i < hiddenSequenceExp.length; ++i) {
            HMMUtilsTest.assertEquals((Object)hiddenSequenceExp[i], hiddenSequenceDec.get(i));
        }
        for (i = 0; i < outputSequenceExp.length; ++i) {
            HMMUtilsTest.assertEquals((Object)outputSequenceExp[i], outputSequenceDec.get(i));
        }
    }

    @Test
    public void testNormalizeModel() {
        DenseVector ip = new DenseVector(new double[]{10.0, 20.0});
        DenseMatrix tr = new DenseMatrix((double[][])new double[][]{{10.0, 10.0}, {20.0, 25.0}});
        DenseMatrix em = new DenseMatrix((double[][])new double[][]{{5.0, 7.0}, {10.0, 15.0}});
        HmmModel model = new HmmModel((Matrix)tr, (Matrix)em, (Vector)ip);
        HmmUtils.normalizeModel((HmmModel)model);
        HmmUtils.validate((HmmModel)model);
    }

    @Test
    public void testTruncateModel() {
        DenseVector ip = new DenseVector(new double[]{1.0E-4, 1.0E-4, 0.9998});
        DenseMatrix tr = new DenseMatrix((double[][])new double[][]{{0.9998, 1.0E-4, 1.0E-4}, {1.0E-4, 0.9998, 1.0E-4}, {1.0E-4, 1.0E-4, 0.9998}});
        DenseMatrix em = new DenseMatrix((double[][])new double[][]{{0.9998, 1.0E-4, 1.0E-4}, {1.0E-4, 0.9998, 1.0E-4}, {1.0E-4, 1.0E-4, 0.9998}});
        HmmModel model = new HmmModel((Matrix)tr, (Matrix)em, (Vector)ip);
        HmmModel sparseModel = HmmUtils.truncateModel((HmmModel)model, (double)0.01);
        HmmUtils.validate((HmmModel)sparseModel);
        Vector sparse_ip = sparseModel.getInitialProbabilities();
        Matrix sparse_tr = sparseModel.getTransitionMatrix();
        Matrix sparse_em = sparseModel.getEmissionMatrix();
        for (int i = 0; i < sparseModel.getNrOfHiddenStates(); ++i) {
            HMMUtilsTest.assertEquals((double)(i == 2 ? 1.0 : 0.0), (double)sparse_ip.getQuick(i), (double)1.0E-6);
            for (int j = 0; j < sparseModel.getNrOfHiddenStates(); ++j) {
                if (i == j) {
                    HMMUtilsTest.assertEquals((double)1.0, (double)sparse_tr.getQuick(i, j), (double)1.0E-6);
                    HMMUtilsTest.assertEquals((double)1.0, (double)sparse_em.getQuick(i, j), (double)1.0E-6);
                    continue;
                }
                HMMUtilsTest.assertEquals((double)0.0, (double)sparse_tr.getQuick(i, j), (double)1.0E-6);
                HMMUtilsTest.assertEquals((double)0.0, (double)sparse_em.getQuick(i, j), (double)1.0E-6);
            }
        }
    }
}

