/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.evaluation;

import java.util.Random;
import org.apache.mahout.classifier.evaluation.Auc;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.jet.random.Normal;
import org.junit.Test;

public final class AucTest
extends MahoutTestCase {
    @Test
    public void testAuc() {
        Auc auc = new Auc();
        RandomWrapper gen = RandomUtils.getRandom();
        auc.setProbabilityScore(false);
        for (int i = 0; i < 100000; ++i) {
            auc.add(0, gen.nextGaussian());
            auc.add(1, gen.nextGaussian() + 1.0);
        }
        AucTest.assertEquals((double)0.76, (double)auc.auc(), (double)0.01);
    }

    @Test
    public void testTies() {
        Auc auc = new Auc();
        RandomWrapper gen = RandomUtils.getRandom();
        auc.setProbabilityScore(false);
        for (int i = 0; i < 100000; ++i) {
            auc.add(0, gen.nextGaussian());
            auc.add(1, gen.nextGaussian() + 1.0);
        }
        auc.add(0, 5.0);
        auc.add(0, 5.0);
        auc.add(0, 5.0);
        auc.add(0, 5.0);
        auc.add(1, 5.0);
        auc.add(1, 5.0);
        auc.add(1, 5.0);
        AucTest.assertEquals((double)0.76, (double)auc.auc(), (double)0.05);
    }

    @Test
    public void testEntropy() {
        Auc auc = new Auc();
        RandomWrapper gen = RandomUtils.getRandom();
        Normal n0 = new Normal(-1.0, 1.0, (Random)gen);
        Normal n1 = new Normal(1.0, 1.0, (Random)gen);
        for (int i = 0; i < 100000; ++i) {
            double score = n0.nextDouble();
            double p = n1.pdf(score) / (n0.pdf(score) + n1.pdf(score));
            auc.add(0, p);
            score = n1.nextDouble();
            p = n1.pdf(score) / (n0.pdf(score) + n1.pdf(score));
            auc.add(1, p);
        }
        Matrix m = auc.entropy();
        AucTest.assertEquals((double)-0.35, (double)m.get(0, 0), (double)0.02);
        AucTest.assertEquals((double)-2.36, (double)m.get(0, 1), (double)0.02);
        AucTest.assertEquals((double)-2.36, (double)m.get(1, 0), (double)0.02);
        AucTest.assertEquals((double)-0.35, (double)m.get(1, 1), (double)0.02);
    }
}

