/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.impl.recommender.SamplingCandidateItemsStrategy;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.junit.Test;

public final class SamplingCandidateItemsStrategyTest
extends TasteTestCase {
    @Test
    public void testStrategy() throws TasteException {
        ArrayList prefsOfUser123 = Lists.newArrayList();
        prefsOfUser123.add(new GenericPreference(123L, 1L, 1.0f));
        ArrayList prefsOfUser456 = Lists.newArrayList();
        prefsOfUser456.add(new GenericPreference(456L, 1L, 1.0f));
        prefsOfUser456.add(new GenericPreference(456L, 2L, 1.0f));
        ArrayList prefsOfUser789 = Lists.newArrayList();
        prefsOfUser789.add(new GenericPreference(789L, 1L, 0.5f));
        prefsOfUser789.add(new GenericPreference(789L, 3L, 1.0f));
        GenericUserPreferenceArray prefArrayOfUser123 = new GenericUserPreferenceArray((List)prefsOfUser123);
        FastByIDMap userData = new FastByIDMap();
        userData.put(123L, (Object)prefArrayOfUser123);
        userData.put(456L, (Object)new GenericUserPreferenceArray((List)prefsOfUser456));
        userData.put(789L, (Object)new GenericUserPreferenceArray((List)prefsOfUser789));
        GenericDataModel dataModel = new GenericDataModel(userData);
        SamplingCandidateItemsStrategy strategy = new SamplingCandidateItemsStrategy(1, 1, 1, dataModel.getNumUsers(), dataModel.getNumItems());
        FastIDSet candidateItems = strategy.getCandidateItems(123L, (PreferenceArray)prefArrayOfUser123, (DataModel)dataModel, false);
        SamplingCandidateItemsStrategyTest.assertTrue((candidateItems.size() <= 1 ? 1 : 0) != 0);
        SamplingCandidateItemsStrategyTest.assertFalse((boolean)candidateItems.contains(1L));
    }
}

