/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.BitSet;
import org.junit.Test;

public final class BitSetTest
extends TasteTestCase {
    private static final int NUM_BITS = 100;

    @Test
    public void testGetSet() {
        BitSet bitSet = new BitSet(100);
        for (int i = 0; i < 100; ++i) {
            BitSetTest.assertFalse((boolean)bitSet.get(i));
        }
        bitSet.set(0);
        bitSet.set(99);
        BitSetTest.assertTrue((boolean)bitSet.get(0));
        BitSetTest.assertTrue((boolean)bitSet.get(99));
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testBounds1() {
        BitSet bitSet = new BitSet(100);
        bitSet.set(1000);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testBounds2() {
        BitSet bitSet = new BitSet(100);
        bitSet.set(-1);
    }

    @Test
    public void testClear() {
        int i;
        BitSet bitSet = new BitSet(100);
        for (i = 0; i < 100; ++i) {
            bitSet.set(i);
        }
        for (i = 0; i < 100; ++i) {
            BitSetTest.assertTrue((boolean)bitSet.get(i));
        }
        bitSet.clear();
        for (i = 0; i < 100; ++i) {
            BitSetTest.assertFalse((boolean)bitSet.get(i));
        }
    }

    @Test
    public void testClone() {
        BitSet bitSet = new BitSet(100);
        bitSet.set(99);
        bitSet = bitSet.clone();
        BitSetTest.assertTrue((boolean)bitSet.get(99));
    }
}

