/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.similarity.item;

import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.cf.taste.hadoop.EntityEntityWritable;
import org.apache.mahout.cf.taste.hadoop.similarity.item.ItemSimilarityJob;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.CosineSimilarity;
import org.apache.mahout.math.hadoop.similarity.cooccurrence.measures.TanimotoCoefficientSimilarity;
import org.apache.mahout.math.map.OpenIntLongHashMap;
import org.easymock.EasyMock;
import org.junit.Test;

public final class ItemSimilarityJobTest
extends TasteTestCase {
    private static final Pattern TAB = Pattern.compile("\t");

    @Test
    public void testMostSimilarItemsPairsMapper() throws Exception {
        OpenIntLongHashMap indexItemIDMap = new OpenIntLongHashMap();
        indexItemIDMap.put(12, 12L);
        indexItemIDMap.put(34, 34L);
        indexItemIDMap.put(56, 56L);
        Mapper.Context context = (Mapper.Context)EasyMock.createMock(Mapper.Context.class);
        context.write((Object)new EntityEntityWritable(34L, 56L), (Object)new DoubleWritable(0.9));
        EasyMock.replay((Object[])new Object[]{context});
        RandomAccessSparseVector vector = new RandomAccessSparseVector(Integer.MAX_VALUE);
        vector.set(12, 0.2);
        vector.set(56, 0.9);
        ItemSimilarityJob.MostSimilarItemPairsMapper mapper = new ItemSimilarityJob.MostSimilarItemPairsMapper();
        ItemSimilarityJobTest.setField(mapper, "indexItemIDMap", indexItemIDMap);
        ItemSimilarityJobTest.setField(mapper, "maxSimilarItemsPerItem", 1);
        mapper.map(new IntWritable(34), new VectorWritable((Vector)vector), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testMostSimilarItemPairsReducer() throws Exception {
        Reducer.Context context = (Reducer.Context)EasyMock.createMock(Reducer.Context.class);
        context.write((Object)new EntityEntityWritable(123L, 456L), (Object)new DoubleWritable(0.5));
        EasyMock.replay((Object[])new Object[]{context});
        new ItemSimilarityJob.MostSimilarItemPairsReducer().reduce(new EntityEntityWritable(123L, 456L), Arrays.asList(new DoubleWritable(0.5), new DoubleWritable(0.5)), context);
        EasyMock.verify((Object[])new Object[]{context});
    }

    @Test
    public void testCompleteJob() throws Exception {
        String line;
        File inputFile = this.getTestTempFile("prefs.txt");
        File outputDir = this.getTestTempDir("output");
        outputDir.delete();
        File tmpDir = this.getTestTempDir("tmp");
        ItemSimilarityJobTest.writeLines(inputFile, "2,1,1", "1,2,1", "3,4,1", "1,3,2", "2,3,1");
        ItemSimilarityJob similarityJob = new ItemSimilarityJob();
        Configuration conf = this.getConfiguration();
        conf.set("mapred.input.dir", inputFile.getAbsolutePath());
        conf.set("mapred.output.dir", outputDir.getAbsolutePath());
        conf.setBoolean("mapred.output.compress", false);
        similarityJob.setConf(conf);
        similarityJob.run(new String[]{"--tempDir", tmpDir.getAbsolutePath(), "--similarityClassname", CosineSimilarity.class.getName()});
        File outPart = outputDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("part-");
            }
        })[0];
        BufferedReader reader = Files.newReader((File)outPart, (Charset)Charsets.UTF_8);
        int currentLine = 1;
        while ((line = reader.readLine()) != null) {
            String[] tokens = TAB.split(line);
            long itemAID = Long.parseLong(tokens[0]);
            long itemBID = Long.parseLong(tokens[1]);
            double similarity = Double.parseDouble(tokens[2]);
            if (currentLine == 1) {
                ItemSimilarityJobTest.assertEquals((long)1L, (long)itemAID);
                ItemSimilarityJobTest.assertEquals((long)3L, (long)itemBID);
                ItemSimilarityJobTest.assertEquals((double)0.45, (double)similarity, (double)0.01);
            }
            if (currentLine == 2) {
                ItemSimilarityJobTest.assertEquals((long)2L, (long)itemAID);
                ItemSimilarityJobTest.assertEquals((long)3L, (long)itemBID);
                ItemSimilarityJobTest.assertEquals((double)0.89, (double)similarity, (double)0.01);
            }
            ++currentLine;
        }
        int linesWritten = currentLine - 1;
        ItemSimilarityJobTest.assertEquals((long)2L, (long)linesWritten);
    }

    @Test
    public void testMaxSimilaritiesPerItem() throws Exception {
        String line;
        File inputFile = this.getTestTempFile("prefsForMaxSimilarities.txt");
        File outputDir = this.getTestTempDir("output");
        outputDir.delete();
        File tmpDir = this.getTestTempDir("tmp");
        ItemSimilarityJobTest.writeLines(inputFile, "1,1,1", "1,3,1", "2,2,1", "2,3,1", "3,1,1", "3,2,1", "4,1,1", "4,2,1", "4,3,1", "5,2,1", "6,1,1", "6,2,1");
        ItemSimilarityJob similarityJob = new ItemSimilarityJob();
        Configuration conf = this.getConfiguration();
        conf.set("mapred.input.dir", inputFile.getAbsolutePath());
        conf.set("mapred.output.dir", outputDir.getAbsolutePath());
        conf.setBoolean("mapred.output.compress", false);
        similarityJob.setConf(conf);
        similarityJob.run(new String[]{"--tempDir", tmpDir.getAbsolutePath(), "--similarityClassname", TanimotoCoefficientSimilarity.class.getName(), "--maxSimilaritiesPerItem", "1"});
        File outPart = outputDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("part-");
            }
        })[0];
        BufferedReader reader = Files.newReader((File)outPart, (Charset)Charsets.UTF_8);
        int currentLine = 1;
        while ((line = reader.readLine()) != null) {
            String[] tokens = TAB.split(line);
            long itemAID = Long.parseLong(tokens[0]);
            long itemBID = Long.parseLong(tokens[1]);
            double similarity = Double.parseDouble(tokens[2]);
            if (currentLine == 1) {
                ItemSimilarityJobTest.assertEquals((long)1L, (long)itemAID);
                ItemSimilarityJobTest.assertEquals((long)2L, (long)itemBID);
                ItemSimilarityJobTest.assertEquals((double)0.5, (double)similarity, (double)1.0E-4);
            }
            if (currentLine == 2) {
                ItemSimilarityJobTest.assertEquals((long)1L, (long)itemAID);
                ItemSimilarityJobTest.assertEquals((long)3L, (long)itemBID);
                ItemSimilarityJobTest.assertEquals((double)0.4, (double)similarity, (double)1.0E-4);
            }
            ++currentLine;
        }
        int linesWritten = currentLine - 1;
        ItemSimilarityJobTest.assertEquals((long)2L, (long)linesWritten);
    }
}

