/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.solver;

import java.io.File;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorIterable;
import org.apache.mahout.math.hadoop.DistributedRowMatrix;
import org.apache.mahout.math.hadoop.TestDistributedRowMatrix;
import org.apache.mahout.math.hadoop.solver.DistributedConjugateGradientSolver;
import org.junit.Test;

public final class TestDistributedConjugateGradientSolver
extends MahoutTestCase {
    private static Vector randomVector(int size, double entryMean) {
        DenseVector v = new DenseVector(size);
        RandomWrapper r = RandomUtils.getRandom();
        for (int i = 0; i < size; ++i) {
            v.setQuick(i, r.nextGaussian() * entryMean);
        }
        return v;
    }

    @Test
    public void testSolver() throws Exception {
        File testData = this.getTestTempDir("testdata");
        DistributedRowMatrix matrix = new TestDistributedRowMatrix().randomDistributedMatrix(10, 10, 10, 10, 10.0, true, testData.getAbsolutePath());
        matrix.setConf(this.getConfiguration());
        Vector vector = TestDistributedConjugateGradientSolver.randomVector(matrix.numCols(), 10.0);
        DistributedConjugateGradientSolver solver = new DistributedConjugateGradientSolver();
        Vector x = solver.solve((VectorIterable)matrix, vector);
        Vector solvedVector = matrix.times(x);
        double distance = Math.sqrt(vector.getDistanceSquared(solvedVector));
        TestDistributedConjugateGradientSolver.assertEquals((double)0.0, (double)distance, (double)1.0E-6);
    }
}

