/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public abstract class DefaultDistanceMeasureTest
extends MahoutTestCase {
    protected abstract DistanceMeasure distanceMeasureFactory();

    @Test
    public void testMeasure() {
        DistanceMeasure distanceMeasure = this.distanceMeasureFactory();
        Vector[] vectors = new Vector[]{new DenseVector(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 1.0}), new DenseVector(new double[]{2.0, 2.0, 2.0, 2.0, 2.0, 2.0}), new DenseVector(new double[]{6.0, 6.0, 6.0, 6.0, 6.0, 6.0}), new DenseVector(new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0})};
        DefaultDistanceMeasureTest.compare(distanceMeasure, vectors);
        vectors = new Vector[4];
        vectors[0] = new RandomAccessSparseVector(5);
        vectors[0].setQuick(0, 1.0);
        vectors[0].setQuick(3, 1.0);
        vectors[0].setQuick(4, 1.0);
        vectors[1] = new RandomAccessSparseVector(5);
        vectors[1].setQuick(0, 2.0);
        vectors[1].setQuick(3, 2.0);
        vectors[1].setQuick(4, 2.0);
        vectors[2] = new RandomAccessSparseVector(5);
        vectors[2].setQuick(0, 6.0);
        vectors[2].setQuick(3, 6.0);
        vectors[2].setQuick(4, 6.0);
        vectors[3] = new RandomAccessSparseVector(5);
        DefaultDistanceMeasureTest.compare(distanceMeasure, vectors);
    }

    private static void compare(DistanceMeasure distanceMeasure, Vector[] vectors) {
        int b;
        int a;
        double[][] distanceMatrix = new double[4][4];
        for (a = 0; a < 4; ++a) {
            for (b = 0; b < 4; ++b) {
                distanceMatrix[a][b] = distanceMeasure.distance(vectors[a], vectors[b]);
            }
        }
        DefaultDistanceMeasureTest.assertEquals((String)"Distance from first vector to itself is not zero", (double)0.0, (double)distanceMatrix[0][0], (double)1.0E-6);
        DefaultDistanceMeasureTest.assertTrue((distanceMatrix[0][0] < distanceMatrix[0][1] ? 1 : 0) != 0);
        DefaultDistanceMeasureTest.assertTrue((distanceMatrix[0][1] < distanceMatrix[0][2] ? 1 : 0) != 0);
        DefaultDistanceMeasureTest.assertEquals((String)"Distance from second vector to itself is not zero", (double)0.0, (double)distanceMatrix[1][1], (double)1.0E-6);
        DefaultDistanceMeasureTest.assertTrue((distanceMatrix[1][0] > distanceMatrix[1][1] ? 1 : 0) != 0);
        DefaultDistanceMeasureTest.assertTrue((distanceMatrix[1][2] > distanceMatrix[1][0] ? 1 : 0) != 0);
        DefaultDistanceMeasureTest.assertEquals((String)"Distance from third vector to itself is not zero", (double)0.0, (double)distanceMatrix[2][2], (double)1.0E-6);
        DefaultDistanceMeasureTest.assertTrue((distanceMatrix[2][0] > distanceMatrix[2][1] ? 1 : 0) != 0);
        DefaultDistanceMeasureTest.assertTrue((distanceMatrix[2][1] > distanceMatrix[2][2] ? 1 : 0) != 0);
        for (a = 0; a < 4; ++a) {
            for (b = 0; b < 4; ++b) {
                DefaultDistanceMeasureTest.assertTrue((String)("Distance between vectors less than zero: " + distanceMatrix[a][b] + " = " + distanceMeasure + ".distance(" + vectors[a].asFormatString() + ", " + vectors[b].asFormatString() + ')'), (distanceMatrix[a][b] >= 0.0 ? 1 : 0) != 0);
                if (vectors[a].plus(vectors[b]).norm(2.0) != 0.0 || !(vectors[a].norm(2.0) > 0.0)) continue;
                DefaultDistanceMeasureTest.assertTrue((String)("Distance from v to -v is equal to zero" + vectors[a].asFormatString() + " = -" + vectors[b].asFormatString()), (distanceMatrix[a][b] > 0.0 ? 1 : 0) != 0);
            }
        }
    }
}

