/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.topdown.postprocessor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.mahout.clustering.ClusteringTestUtils;
import org.apache.mahout.clustering.canopy.CanopyDriver;
import org.apache.mahout.clustering.kmeans.KMeansDriver;
import org.apache.mahout.clustering.topdown.postprocessor.ClusterCountReader;
import org.apache.mahout.common.DummyOutputCollector;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class ClusterCountReaderTest
extends MahoutTestCase {
    public static final double[][] REFERENCE = new double[][]{{1.0, 1.0}, {2.0, 1.0}, {1.0, 2.0}, {4.0, 4.0}, {5.0, 4.0}, {4.0, 5.0}, {5.0, 5.0}};
    private FileSystem fs;
    private Path outputPathForCanopy;
    private Path outputPathForKMeans;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration conf = this.getConfiguration();
        this.fs = FileSystem.get((Configuration)conf);
    }

    public static List<VectorWritable> getPointsWritable(double[][] raw) {
        ArrayList points = Lists.newArrayList();
        for (double[] fr : raw) {
            RandomAccessSparseVector vec = new RandomAccessSparseVector(fr.length);
            vec.assign(fr);
            points.add(new VectorWritable((Vector)vec));
        }
        return points;
    }

    @Test
    public void testGetNumberOfClusters() throws Exception {
        List<VectorWritable> points = ClusterCountReaderTest.getPointsWritable(REFERENCE);
        Path pointsPath = this.getTestTempDirPath("points");
        Configuration conf = this.getConfiguration();
        ClusteringTestUtils.writePointsToFile(points, new Path(pointsPath, "file1"), this.fs, conf);
        ClusteringTestUtils.writePointsToFile(points, new Path(pointsPath, "file2"), this.fs, conf);
        this.outputPathForCanopy = this.getTestTempDirPath("canopy");
        this.outputPathForKMeans = this.getTestTempDirPath("kmeans");
        this.topLevelClustering(pointsPath, conf);
        int numberOfClusters = ClusterCountReader.getNumberOfClusters((Path)this.outputPathForKMeans, (Configuration)conf);
        Assert.assertEquals((long)2L, (long)numberOfClusters);
        ClusterCountReaderTest.verifyThatNumberOfClustersIsCorrect(conf, new Path(this.outputPathForKMeans, new Path("clusteredPoints")));
    }

    private void topLevelClustering(Path pointsPath, Configuration conf) throws IOException, InterruptedException, ClassNotFoundException {
        ManhattanDistanceMeasure measure = new ManhattanDistanceMeasure();
        CanopyDriver.run((Configuration)conf, (Path)pointsPath, (Path)this.outputPathForCanopy, (DistanceMeasure)measure, (double)4.0, (double)3.0, (boolean)true, (double)0.0, (boolean)true);
        Path clustersIn = new Path(this.outputPathForCanopy, new Path("clusters-0-final"));
        KMeansDriver.run((Configuration)conf, (Path)pointsPath, (Path)clustersIn, (Path)this.outputPathForKMeans, (double)1.0, (int)1, (boolean)true, (double)0.0, (boolean)true);
    }

    private static void verifyThatNumberOfClustersIsCorrect(Configuration conf, Path clusteredPointsPath) {
        DummyOutputCollector<WritableComparable, Writable> collector = new DummyOutputCollector<WritableComparable, Writable>();
        for (Pair record : new SequenceFileIterable(new Path(clusteredPointsPath, "part-m-0"), conf)) {
            collector.collect((WritableComparable)record.getFirst(), (Writable)record.getSecond());
        }
        int clusterSize = collector.getKeys().size();
        ClusterCountReaderTest.assertEquals((long)2L, (long)clusterSize);
    }
}

