/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.clustering.spectral.VectorMatrixMultiplicationJob;
import org.apache.mahout.common.DummyRecordWriter;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.junit.Test;

public class TestVectorMatrixMultiplicationJob
extends MahoutTestCase {
    private static final double[][] MATRIX = new double[][]{{1.0, 1.0}, {2.0, 3.0}};
    private static final double[] VECTOR = new double[]{9.0, 16.0};

    @Test
    public void testVectorMatrixMultiplicationMapper() throws Exception {
        int i;
        VectorMatrixMultiplicationJob.VectorMatrixMultiplicationMapper mapper = new VectorMatrixMultiplicationJob.VectorMatrixMultiplicationMapper();
        Configuration conf = this.getConfiguration();
        DenseVector toSave = new DenseVector(VECTOR);
        DummyRecordWriter writer = new DummyRecordWriter();
        Mapper.Context context = DummyRecordWriter.build(mapper, conf, writer);
        mapper.setup((Vector)toSave);
        for (i = 0; i < MATRIX.length; ++i) {
            RandomAccessSparseVector v = new RandomAccessSparseVector(MATRIX[i].length);
            v.assign(MATRIX[i]);
            mapper.map(new IntWritable(i), new VectorWritable((Vector)v), context);
        }
        TestVectorMatrixMultiplicationJob.assertEquals((String)"Number of map results", (long)MATRIX.length, (long)writer.getData().size());
        for (i = 0; i < MATRIX.length; ++i) {
            List list = writer.getValue(new IntWritable(i));
            TestVectorMatrixMultiplicationJob.assertEquals((String)"Only one vector per key", (long)1L, (long)list.size());
            Vector v = ((VectorWritable)list.get(0)).get();
            for (int j = 0; j < MATRIX[i].length; ++j) {
                double total = Math.sqrt(VECTOR[i]) * Math.sqrt(VECTOR[j]) * MATRIX[i][j];
                TestVectorMatrixMultiplicationJob.assertEquals((String)"Product matrix elements", (double)total, (double)v.get(j), (double)1.0E-6);
            }
        }
    }
}

