/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sequencelearning.hmm;

import org.apache.mahout.classifier.sequencelearning.hmm.HMMTestBase;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmAlgorithms;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmEvaluator;
import org.apache.mahout.classifier.sequencelearning.hmm.HmmModel;
import org.apache.mahout.math.Matrix;
import org.junit.Test;

public class HMMEvaluatorTest
extends HMMTestBase {
    @Test
    public void testModelLikelihood() {
        Matrix alpha = HmmAlgorithms.forwardAlgorithm((HmmModel)this.getModel(), (int[])this.getSequence(), (boolean)false);
        Matrix beta = HmmAlgorithms.backwardAlgorithm((HmmModel)this.getModel(), (int[])this.getSequence(), (boolean)false);
        double forwardLikelihood = HmmEvaluator.modelLikelihood((Matrix)alpha, (boolean)false);
        double backwardLikelihood = HmmEvaluator.modelLikelihood((HmmModel)this.getModel(), (int[])this.getSequence(), (Matrix)beta, (boolean)false);
        HMMEvaluatorTest.assertEquals((double)forwardLikelihood, (double)backwardLikelihood, (double)1.0E-6);
        HMMEvaluatorTest.assertEquals((double)1.8425E-4, (double)forwardLikelihood, (double)1.0E-6);
    }

    @Test
    public void testScaledModelLikelihood() {
        Matrix alpha = HmmAlgorithms.forwardAlgorithm((HmmModel)this.getModel(), (int[])this.getSequence(), (boolean)true);
        Matrix beta = HmmAlgorithms.backwardAlgorithm((HmmModel)this.getModel(), (int[])this.getSequence(), (boolean)true);
        double forwardLikelihood = HmmEvaluator.modelLikelihood((Matrix)alpha, (boolean)true);
        double backwardLikelihood = HmmEvaluator.modelLikelihood((HmmModel)this.getModel(), (int[])this.getSequence(), (Matrix)beta, (boolean)true);
        HMMEvaluatorTest.assertEquals((double)forwardLikelihood, (double)backwardLikelihood, (double)1.0E-6);
        HMMEvaluatorTest.assertEquals((double)1.8425E-4, (double)forwardLikelihood, (double)1.0E-6);
    }
}

