/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.similarity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.similarity.GenericItemSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.PearsonCorrelationSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.SimilarityTestCase;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.junit.Test;

public final class GenericItemSimilarityTest
extends SimilarityTestCase {
    @Test
    public void testSimple() {
        ArrayList similarities = Lists.newArrayList();
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(1L, 2L, 0.5));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(2L, 1L, 0.6));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(1L, 1L, 0.5));
        similarities.add(new GenericItemSimilarity.ItemItemSimilarity(1L, 3L, 0.3));
        GenericItemSimilarity itemCorrelation = new GenericItemSimilarity((Iterable)similarities);
        GenericItemSimilarityTest.assertEquals((double)1.0, (double)itemCorrelation.itemSimilarity(1L, 1L), (double)1.0E-6);
        GenericItemSimilarityTest.assertEquals((double)0.6, (double)itemCorrelation.itemSimilarity(1L, 2L), (double)1.0E-6);
        GenericItemSimilarityTest.assertEquals((double)0.6, (double)itemCorrelation.itemSimilarity(2L, 1L), (double)1.0E-6);
        GenericItemSimilarityTest.assertEquals((double)0.3, (double)itemCorrelation.itemSimilarity(1L, 3L), (double)1.0E-6);
        GenericItemSimilarityTest.assertTrue((boolean)Double.isNaN(itemCorrelation.itemSimilarity(3L, 4L)));
    }

    @Test
    public void testFromCorrelation() throws Exception {
        DataModel dataModel = GenericItemSimilarityTest.getDataModel(new long[]{1L, 2L, 3L}, new Double[][]{{1.0, 2.0}, {2.0, 5.0}, {3.0, 6.0}});
        PearsonCorrelationSimilarity otherSimilarity = new PearsonCorrelationSimilarity(dataModel);
        GenericItemSimilarity itemSimilarity = new GenericItemSimilarity((ItemSimilarity)otherSimilarity, dataModel);
        GenericItemSimilarityTest.assertCorrelationEquals(1.0, itemSimilarity.itemSimilarity(0L, 0L));
        GenericItemSimilarityTest.assertCorrelationEquals(0.960768922830523, itemSimilarity.itemSimilarity(0L, 1L));
    }

    @Test
    public void testAllSimilaritiesWithoutIndex() throws TasteException {
        List<GenericItemSimilarity.ItemItemSimilarity> itemItemSimilarities = Arrays.asList(new GenericItemSimilarity.ItemItemSimilarity(1L, 2L, 0.2), new GenericItemSimilarity.ItemItemSimilarity(1L, 3L, 0.2), new GenericItemSimilarity.ItemItemSimilarity(2L, 1L, 0.2), new GenericItemSimilarity.ItemItemSimilarity(3L, 5L, 0.2), new GenericItemSimilarity.ItemItemSimilarity(3L, 4L, 0.2));
        GenericItemSimilarity similarity = new GenericItemSimilarity(itemItemSimilarities);
        GenericItemSimilarityTest.assertTrue((boolean)GenericItemSimilarityTest.containsExactly(similarity.allSimilarItemIDs(1L), 2L, 3L));
        GenericItemSimilarityTest.assertTrue((boolean)GenericItemSimilarityTest.containsExactly(similarity.allSimilarItemIDs(2L), 1L));
        GenericItemSimilarityTest.assertTrue((boolean)GenericItemSimilarityTest.containsExactly(similarity.allSimilarItemIDs(3L), 1L, 5L, 4L));
        GenericItemSimilarityTest.assertTrue((boolean)GenericItemSimilarityTest.containsExactly(similarity.allSimilarItemIDs(4L), 3L));
        GenericItemSimilarityTest.assertTrue((boolean)GenericItemSimilarityTest.containsExactly(similarity.allSimilarItemIDs(5L), 3L));
    }

    @Test
    public void testAllSimilaritiesWithIndex() throws TasteException {
        List<GenericItemSimilarity.ItemItemSimilarity> itemItemSimilarities = Arrays.asList(new GenericItemSimilarity.ItemItemSimilarity(1L, 2L, 0.2), new GenericItemSimilarity.ItemItemSimilarity(1L, 3L, 0.2), new GenericItemSimilarity.ItemItemSimilarity(2L, 1L, 0.2), new GenericItemSimilarity.ItemItemSimilarity(3L, 5L, 0.2), new GenericItemSimilarity.ItemItemSimilarity(3L, 4L, 0.2));
        GenericItemSimilarity similarity = new GenericItemSimilarity(itemItemSimilarities);
        GenericItemSimilarityTest.assertTrue((boolean)GenericItemSimilarityTest.containsExactly(similarity.allSimilarItemIDs(1L), 2L, 3L));
        GenericItemSimilarityTest.assertTrue((boolean)GenericItemSimilarityTest.containsExactly(similarity.allSimilarItemIDs(2L), 1L));
        GenericItemSimilarityTest.assertTrue((boolean)GenericItemSimilarityTest.containsExactly(similarity.allSimilarItemIDs(3L), 1L, 5L, 4L));
        GenericItemSimilarityTest.assertTrue((boolean)GenericItemSimilarityTest.containsExactly(similarity.allSimilarItemIDs(4L), 3L));
        GenericItemSimilarityTest.assertTrue((boolean)GenericItemSimilarityTest.containsExactly(similarity.allSimilarItemIDs(5L), 3L));
    }

    private static boolean containsExactly(long[] allIDs, long ... shouldContainID) {
        return new FastIDSet(allIDs).intersectionSize(new FastIDSet(shouldContainID)) == shouldContainID.length;
    }
}

