/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.model.GenericItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.model.Preference;
import org.junit.Test;

public final class GenericItemPreferenceArrayTest
extends TasteTestCase {
    @Test
    public void testUserID() {
        GenericItemPreferenceArray prefs = new GenericItemPreferenceArray(3);
        GenericItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        prefs.setItemID(0, 1L);
        GenericItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(0));
        GenericItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(1));
        GenericItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(2));
    }

    @Test
    public void testItemID() {
        GenericItemPreferenceArray prefs = new GenericItemPreferenceArray(3);
        GenericItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        prefs.setUserID(0, 1L);
        prefs.setUserID(1, 2L);
        prefs.setUserID(2, 3L);
        GenericItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(0));
        GenericItemPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getUserID(1));
        GenericItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getUserID(2));
    }

    @Test
    public void testSetValue() {
        GenericItemPreferenceArray prefs = new GenericItemPreferenceArray(3);
        GenericItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        prefs.setValue(0, 1.0f);
        prefs.setValue(1, 2.0f);
        prefs.setValue(2, 3.0f);
        GenericItemPreferenceArrayTest.assertEquals((double)1.0, (double)prefs.getValue(0), (double)1.0E-6);
        GenericItemPreferenceArrayTest.assertEquals((double)2.0, (double)prefs.getValue(1), (double)1.0E-6);
        GenericItemPreferenceArrayTest.assertEquals((double)3.0, (double)prefs.getValue(2), (double)1.0E-6);
    }

    @Test
    public void testHasPref() {
        GenericItemPreferenceArray prefs = new GenericItemPreferenceArray(3);
        prefs.set(0, (Preference)new GenericPreference(1L, 3L, 5.0f));
        GenericItemPreferenceArrayTest.assertTrue((boolean)prefs.hasPrefWithItemID(3L));
        GenericItemPreferenceArrayTest.assertTrue((boolean)prefs.hasPrefWithUserID(1L));
        GenericItemPreferenceArrayTest.assertFalse((boolean)prefs.hasPrefWithItemID(2L));
        GenericItemPreferenceArrayTest.assertFalse((boolean)prefs.hasPrefWithUserID(2L));
    }

    @Test
    public void testSort() {
        GenericItemPreferenceArray prefs = new GenericItemPreferenceArray(3);
        prefs.set(0, (Preference)new GenericPreference(3L, 1L, 5.0f));
        prefs.set(1, (Preference)new GenericPreference(1L, 1L, 5.0f));
        prefs.set(2, (Preference)new GenericPreference(2L, 1L, 5.0f));
        prefs.sortByUser();
        GenericItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(0));
        GenericItemPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getUserID(1));
        GenericItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getUserID(2));
    }

    @Test
    public void testSortValue() {
        GenericItemPreferenceArray prefs = new GenericItemPreferenceArray(3);
        prefs.set(0, (Preference)new GenericPreference(3L, 1L, 5.0f));
        prefs.set(1, (Preference)new GenericPreference(1L, 1L, 4.0f));
        prefs.set(2, (Preference)new GenericPreference(2L, 1L, 3.0f));
        prefs.sortByValue();
        GenericItemPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getUserID(0));
        GenericItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(1));
        GenericItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getUserID(2));
        prefs.sortByValueReversed();
        GenericItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getUserID(0));
        GenericItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(1));
        GenericItemPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getUserID(2));
    }

    @Test
    public void testClone() {
        GenericItemPreferenceArray prefs = new GenericItemPreferenceArray(3);
        prefs.set(0, (Preference)new GenericPreference(3L, 1L, 5.0f));
        prefs.set(1, (Preference)new GenericPreference(1L, 1L, 4.0f));
        prefs.set(2, (Preference)new GenericPreference(2L, 1L, 3.0f));
        prefs = prefs.clone();
        GenericItemPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getUserID(0));
        GenericItemPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(1));
        GenericItemPreferenceArrayTest.assertEquals((double)3.0, (double)prefs.getValue(2), (double)1.0E-6);
    }
}

