/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model;

import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.model.BooleanPreference;
import org.apache.mahout.cf.taste.impl.model.BooleanUserPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.model.Preference;
import org.junit.Test;

public final class BooleanUserPreferenceArrayTest
extends TasteTestCase {
    @Test
    public void testUserID() {
        BooleanUserPreferenceArray prefs = new BooleanUserPreferenceArray(3);
        BooleanUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        prefs.setUserID(0, 1L);
        BooleanUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(0));
        BooleanUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(1));
        BooleanUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(2));
    }

    @Test
    public void testItemID() {
        BooleanUserPreferenceArray prefs = new BooleanUserPreferenceArray(3);
        BooleanUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        prefs.setItemID(0, 1L);
        prefs.setItemID(1, 2L);
        prefs.setItemID(2, 3L);
        BooleanUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(0));
        BooleanUserPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getItemID(1));
        BooleanUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getItemID(2));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testSetValue() {
        BooleanUserPreferenceArray prefs = new BooleanUserPreferenceArray(3);
        BooleanUserPreferenceArrayTest.assertEquals((double)1.0, (double)prefs.getValue(2), (double)1.0E-6);
        BooleanUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.length());
        prefs.setValue(0, 1.0f);
    }

    @Test
    public void testHasPref() {
        BooleanUserPreferenceArray prefs = new BooleanUserPreferenceArray(3);
        prefs.set(0, (Preference)new GenericPreference(1L, 3L, 5.0f));
        BooleanUserPreferenceArrayTest.assertTrue((boolean)prefs.hasPrefWithItemID(3L));
        BooleanUserPreferenceArrayTest.assertTrue((boolean)prefs.hasPrefWithUserID(1L));
        BooleanUserPreferenceArrayTest.assertFalse((boolean)prefs.hasPrefWithItemID(2L));
        BooleanUserPreferenceArrayTest.assertFalse((boolean)prefs.hasPrefWithUserID(2L));
    }

    @Test
    public void testSort() {
        BooleanUserPreferenceArray prefs = new BooleanUserPreferenceArray(3);
        prefs.set(0, (Preference)new BooleanPreference(1L, 3L));
        prefs.set(1, (Preference)new BooleanPreference(1L, 1L));
        prefs.set(2, (Preference)new BooleanPreference(1L, 2L));
        prefs.sortByItem();
        BooleanUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getItemID(0));
        BooleanUserPreferenceArrayTest.assertEquals((long)2L, (long)prefs.getItemID(1));
        BooleanUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getItemID(2));
    }

    @Test
    public void testClone() {
        BooleanUserPreferenceArray prefs = new BooleanUserPreferenceArray(3);
        prefs.set(0, (Preference)new BooleanPreference(1L, 3L));
        prefs.set(1, (Preference)new BooleanPreference(1L, 1L));
        prefs.set(2, (Preference)new BooleanPreference(1L, 2L));
        prefs = prefs.clone();
        BooleanUserPreferenceArrayTest.assertEquals((long)3L, (long)prefs.getItemID(0));
        BooleanUserPreferenceArrayTest.assertEquals((long)1L, (long)prefs.getUserID(1));
    }
}

