/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop;

import java.util.List;
import org.apache.mahout.cf.taste.hadoop.MutableRecommendedItem;
import org.apache.mahout.cf.taste.hadoop.TopItemsQueue;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.junit.Test;

public class TopItemsQueueTest
extends TasteTestCase {
    @Test
    public void topK() {
        float[] ratings = new float[]{0.5f, 0.6f, 0.7f, 2.0f, 0.0f};
        List<RecommendedItem> topItems = TopItemsQueueTest.findTop(ratings, 2);
        TopItemsQueueTest.assertEquals((long)2L, (long)topItems.size());
        TopItemsQueueTest.assertEquals((long)3L, (long)topItems.get(0).getItemID());
        TopItemsQueueTest.assertEquals((double)2.0, (double)topItems.get(0).getValue(), (double)1.0E-6);
        TopItemsQueueTest.assertEquals((long)2L, (long)topItems.get(1).getItemID());
        TopItemsQueueTest.assertEquals((double)0.7f, (double)topItems.get(1).getValue(), (double)1.0E-6);
    }

    @Test
    public void topKInputSmallerThanK() {
        float[] ratings = new float[]{0.7f, 2.0f};
        List<RecommendedItem> topItems = TopItemsQueueTest.findTop(ratings, 3);
        TopItemsQueueTest.assertEquals((long)2L, (long)topItems.size());
        TopItemsQueueTest.assertEquals((long)1L, (long)topItems.get(0).getItemID());
        TopItemsQueueTest.assertEquals((double)2.0, (double)topItems.get(0).getValue(), (double)1.0E-6);
        TopItemsQueueTest.assertEquals((long)0L, (long)topItems.get(1).getItemID());
        TopItemsQueueTest.assertEquals((double)0.7f, (double)topItems.get(1).getValue(), (double)1.0E-6);
    }

    private static List<RecommendedItem> findTop(float[] ratings, int k) {
        TopItemsQueue queue = new TopItemsQueue(k);
        for (int item = 0; item < ratings.length; ++item) {
            MutableRecommendedItem top = (MutableRecommendedItem)queue.top();
            if (!(ratings[item] > top.getValue())) continue;
            top.set((long)item, ratings[item]);
            queue.updateTop();
        }
        return queue.getTopItems();
    }
}

