/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.math.Varint;

public class SplitPartitionedWritable
implements WritableComparable<SplitPartitionedWritable> {
    private int taskId;
    private long taskItemOrdinal;

    public SplitPartitionedWritable(Mapper.Context mapperContext) {
        this.taskId = mapperContext.getTaskAttemptID().getTaskID().getId();
    }

    public SplitPartitionedWritable() {
    }

    public int getTaskId() {
        return this.taskId;
    }

    public long getTaskItemOrdinal() {
        return this.taskItemOrdinal;
    }

    public void incrementItemOrdinal() {
        ++this.taskItemOrdinal;
    }

    public void setTaskItemOrdinal(long taskItemOrdinal) {
        this.taskItemOrdinal = taskItemOrdinal;
    }

    public void readFields(DataInput in) throws IOException {
        this.taskId = Varint.readUnsignedVarInt((DataInput)in);
        this.taskItemOrdinal = Varint.readUnsignedVarLong((DataInput)in);
    }

    public void write(DataOutput out) throws IOException {
        Varint.writeUnsignedVarInt((int)this.taskId, (DataOutput)out);
        Varint.writeUnsignedVarLong((long)this.taskItemOrdinal, (DataOutput)out);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.taskId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SplitPartitionedWritable other = (SplitPartitionedWritable)obj;
        return this.taskId == other.taskId;
    }

    public int compareTo(SplitPartitionedWritable o) {
        if (this.taskId < o.taskId) {
            return -1;
        }
        if (this.taskId > o.taskId) {
            return 1;
        }
        if (this.taskItemOrdinal < o.taskItemOrdinal) {
            return -1;
        }
        if (this.taskItemOrdinal > o.taskItemOrdinal) {
            return 1;
        }
        return 0;
    }

    public static final class SplitGroupingComparator
    extends WritableComparator
    implements Serializable {
        public SplitGroupingComparator() {
            super(SplitPartitionedWritable.class, true);
        }

        public int compare(Object a, Object b) {
            SplitPartitionedWritable o1 = (SplitPartitionedWritable)a;
            SplitPartitionedWritable o2 = (SplitPartitionedWritable)b;
            if (o1.taskId < o2.taskId) {
                return -1;
            }
            if (o1.taskId > o2.taskId) {
                return 1;
            }
            return 0;
        }
    }
}

