/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.classify;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.io.Text;
import org.apache.mahout.clustering.AbstractCluster;
import org.apache.mahout.clustering.classify.WeightedVectorWritable;
import org.apache.mahout.math.Vector;

public class WeightedPropertyVectorWritable
extends WeightedVectorWritable {
    private Map<Text, Text> properties;

    public WeightedPropertyVectorWritable() {
    }

    public WeightedPropertyVectorWritable(Map<Text, Text> properties) {
        this.properties = properties;
    }

    public WeightedPropertyVectorWritable(double weight, Vector vector, Map<Text, Text> properties) {
        super(weight, vector);
        this.properties = properties;
    }

    public Map<Text, Text> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<Text, Text> properties) {
        this.properties = properties;
    }

    @Override
    public void readFields(DataInput in) throws IOException {
        super.readFields(in);
        int size = in.readInt();
        if (size > 0) {
            this.properties = new HashMap<Text, Text>();
            for (int i = 0; i < size; ++i) {
                Text key = new Text(in.readUTF());
                Text val = new Text(in.readUTF());
                this.properties.put(key, val);
            }
        }
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeInt(this.properties != null ? this.properties.size() : 0);
        if (this.properties != null) {
            for (Map.Entry<Text, Text> entry : this.properties.entrySet()) {
                out.writeUTF(entry.getKey().toString());
                out.writeUTF(entry.getValue().toString());
            }
        }
    }

    @Override
    public String toString() {
        Vector vector = this.getVector();
        StringBuilder bldr = new StringBuilder("wt: ").append(this.getWeight()).append(' ');
        if (this.properties != null && !this.properties.isEmpty()) {
            for (Map.Entry<Text, Text> entry : this.properties.entrySet()) {
                bldr.append(entry.getKey().toString()).append(": ").append(entry.getValue().toString()).append(' ');
            }
        }
        bldr.append(" vec: ").append(vector == null ? "null" : AbstractCluster.formatVector(vector, null));
        return bldr.toString();
    }
}

