/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.node;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.mahout.classifier.df.data.Instance;
import org.apache.mahout.classifier.df.node.Node;

public class NumericalNode
extends Node {
    private int attr;
    private double split;
    private Node loChild;
    private Node hiChild;

    public NumericalNode() {
    }

    public NumericalNode(int attr, double split, Node loChild, Node hiChild) {
        this.attr = attr;
        this.split = split;
        this.loChild = loChild;
        this.hiChild = hiChild;
    }

    @Override
    public double classify(Instance instance) {
        if (instance.get(this.attr) < this.split) {
            return this.loChild.classify(instance);
        }
        return this.hiChild.classify(instance);
    }

    @Override
    public long maxDepth() {
        return 1L + Math.max(this.loChild.maxDepth(), this.hiChild.maxDepth());
    }

    @Override
    public long nbNodes() {
        return 1L + this.loChild.nbNodes() + this.hiChild.nbNodes();
    }

    @Override
    protected Node.Type getType() {
        return Node.Type.NUMERICAL;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof NumericalNode)) {
            return false;
        }
        NumericalNode node = (NumericalNode)obj;
        return this.attr == node.attr && this.split == node.split && this.loChild.equals(node.loChild) && this.hiChild.equals(node.hiChild);
    }

    public int hashCode() {
        return this.attr + (int)Double.doubleToLongBits(this.split) + this.loChild.hashCode() + this.hiChild.hashCode();
    }

    @Override
    protected String getString() {
        return this.loChild.toString() + ',' + this.hiChild.toString();
    }

    public void readFields(DataInput in) throws IOException {
        this.attr = in.readInt();
        this.split = in.readDouble();
        this.loChild = Node.read(in);
        this.hiChild = Node.read(in);
    }

    @Override
    protected void writeNode(DataOutput out) throws IOException {
        out.writeInt(this.attr);
        out.writeDouble(this.split);
        this.loChild.write(out);
        this.hiChild.write(out);
    }
}

