/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.classifier.df.builder.TreeBuilder;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.mapreduce.Builder;

public class MapredMapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT>
extends Mapper<KEYIN, VALUEIN, KEYOUT, VALUEOUT> {
    private boolean noOutput;
    private TreeBuilder treeBuilder;
    private Dataset dataset;

    protected boolean isOutput() {
        return !this.noOutput;
    }

    protected TreeBuilder getTreeBuilder() {
        return this.treeBuilder;
    }

    protected Dataset getDataset() {
        return this.dataset;
    }

    protected void setup(Mapper.Context context) throws IOException, InterruptedException {
        super.setup(context);
        Configuration conf = context.getConfiguration();
        this.configure(!Builder.isOutput(conf), Builder.getTreeBuilder(conf), Builder.loadDataset(conf));
    }

    protected void configure(boolean noOutput, TreeBuilder treeBuilder, Dataset dataset) {
        Preconditions.checkArgument((treeBuilder != null ? 1 : 0) != 0, (Object)"TreeBuilder not found in the Job parameters");
        this.noOutput = noOutput;
        this.treeBuilder = treeBuilder;
        this.dataset = dataset;
    }
}

