/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.vectorizer.encoders.AdaptiveWordValueEncoder;
import org.apache.mahout.vectorizer.encoders.StaticWordValueEncoder;
import org.junit.Test;

public final class WordLikeValueEncoderTest
extends MahoutTestCase {
    @Test
    public void testAddToVector() {
        StaticWordValueEncoder enc = new StaticWordValueEncoder("word");
        DenseVector v = new DenseVector(200);
        enc.addToVector("word1", (Vector)v);
        enc.addToVector("word2", (Vector)v);
        Iterator i = v.nonZeroes().iterator();
        UnmodifiableIterator j = ImmutableList.of((Object)7, (Object)118, (Object)119, (Object)199).iterator();
        while (i.hasNext()) {
            Vector.Element element = (Vector.Element)i.next();
            WordLikeValueEncoderTest.assertEquals((long)((Integer)j.next()).intValue(), (long)element.index());
            WordLikeValueEncoderTest.assertEquals((double)1.0, (double)element.get(), (double)0.0);
        }
        WordLikeValueEncoderTest.assertFalse((boolean)j.hasNext());
    }

    @Test
    public void testAsString() {
        Locale.setDefault(Locale.ENGLISH);
        StaticWordValueEncoder enc = new StaticWordValueEncoder("word");
        WordLikeValueEncoderTest.assertEquals((Object)"word:w1:1.0000", (Object)enc.asString("w1"));
    }

    @Test
    public void testStaticWeights() {
        StaticWordValueEncoder enc = new StaticWordValueEncoder("word");
        enc.setDictionary((Map)ImmutableMap.of((Object)"word1", (Object)3.0, (Object)"word2", (Object)1.5));
        DenseVector v = new DenseVector(200);
        enc.addToVector("word1", (Vector)v);
        enc.addToVector("word2", (Vector)v);
        enc.addToVector("word3", (Vector)v);
        Iterator i = v.nonZeroes().iterator();
        UnmodifiableIterator j = ImmutableList.of((Object)7, (Object)101, (Object)118, (Object)119, (Object)152, (Object)199).iterator();
        UnmodifiableIterator k = ImmutableList.of((Object)3.0, (Object)0.75, (Object)1.5, (Object)1.5, (Object)0.75, (Object)3.0).iterator();
        while (i.hasNext()) {
            Vector.Element element = (Vector.Element)i.next();
            WordLikeValueEncoderTest.assertEquals((long)((Integer)j.next()).intValue(), (long)element.index());
        }
        for (Vector.Element element : v.nonZeroes()) {
            WordLikeValueEncoderTest.assertEquals((String)String.format("checking v[%d]", element.index()), (double)((Double)k.next()), (double)element.get(), (double)0.0);
        }
        WordLikeValueEncoderTest.assertFalse((boolean)j.hasNext());
    }

    @Test
    public void testDynamicWeights() {
        AdaptiveWordValueEncoder enc = new AdaptiveWordValueEncoder("word");
        DenseVector v = new DenseVector(200);
        enc.addToVector("word1", (Vector)v);
        enc.addToVector("word2", (Vector)v);
        enc.addToVector("word1", (Vector)v);
        enc.addToVector("word3", (Vector)v);
        Iterator i = v.nonZeroes().iterator();
        UnmodifiableIterator j = ImmutableList.of((Object)7, (Object)101, (Object)118, (Object)119, (Object)152, (Object)199).iterator();
        UnmodifiableIterator k = ImmutableList.of((Object)(Math.log(1.3333333333333333) + Math.log(1.8)), (Object)Math.log(4.0), (Object)Math.log(2.3333333333333335), (Object)Math.log(2.3333333333333335), (Object)Math.log(4.0), (Object)(Math.log(1.3333333333333333) + Math.log(1.8))).iterator();
        while (i.hasNext()) {
            Vector.Element element = (Vector.Element)i.next();
            WordLikeValueEncoderTest.assertEquals((long)((Integer)j.next()).intValue(), (long)element.index());
            WordLikeValueEncoderTest.assertEquals((double)((Double)k.next()), (double)element.get(), (double)1.0E-6);
        }
        WordLikeValueEncoderTest.assertFalse((boolean)j.hasNext());
    }
}

