/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.vectorizer.encoders.ConstantValueEncoder;
import org.junit.Test;

public final class ConstantValueEncoderTest
extends MahoutTestCase {
    @Test
    public void testAddToVector() {
        ConstantValueEncoder enc = new ConstantValueEncoder("foo");
        DenseVector v1 = new DenseVector(20);
        enc.addToVector((byte[])null, -123.0, (Vector)v1);
        ConstantValueEncoderTest.assertEquals((double)-123.0, (double)v1.minValue(), (double)0.0);
        ConstantValueEncoderTest.assertEquals((double)0.0, (double)v1.maxValue(), (double)0.0);
        ConstantValueEncoderTest.assertEquals((double)123.0, (double)v1.norm(1.0), (double)0.0);
        v1 = new DenseVector(20);
        enc.addToVector((byte[])null, 123.0, (Vector)v1);
        ConstantValueEncoderTest.assertEquals((double)123.0, (double)v1.maxValue(), (double)0.0);
        ConstantValueEncoderTest.assertEquals((double)0.0, (double)v1.minValue(), (double)0.0);
        ConstantValueEncoderTest.assertEquals((double)123.0, (double)v1.norm(1.0), (double)0.0);
        DenseVector v2 = new DenseVector(20);
        enc.setProbes(2);
        enc.addToVector((byte[])null, 123.0, (Vector)v2);
        ConstantValueEncoderTest.assertEquals((double)123.0, (double)v2.maxValue(), (double)0.0);
        ConstantValueEncoderTest.assertEquals((double)246.0, (double)v2.norm(1.0), (double)0.0);
        v1 = v2.minus((Vector)v1);
        ConstantValueEncoderTest.assertEquals((double)123.0, (double)v1.maxValue(), (double)0.0);
        ConstantValueEncoderTest.assertEquals((double)123.0, (double)v1.norm(1.0), (double)0.0);
        DenseVector v3 = new DenseVector(20);
        enc.setProbes(2);
        enc.addToVector((byte[])null, 100.0, (Vector)v3);
        v1 = v2.minus((Vector)v3);
        ConstantValueEncoderTest.assertEquals((double)23.0, (double)v1.maxValue(), (double)0.0);
        ConstantValueEncoderTest.assertEquals((double)46.0, (double)v1.norm(1.0), (double)0.0);
        enc.addToVector((byte[])null, 7.0, (Vector)v1);
        ConstantValueEncoderTest.assertEquals((double)30.0, (double)v1.maxValue(), (double)0.0);
        ConstantValueEncoderTest.assertEquals((double)60.0, (double)v1.norm(1.0), (double)0.0);
        ConstantValueEncoderTest.assertEquals((double)30.0, (double)v1.get(9), (double)0.0);
        ConstantValueEncoderTest.assertEquals((double)30.0, (double)v1.get(10), (double)0.0);
    }

    @Test
    public void testAsString() {
        ConstantValueEncoder enc = new ConstantValueEncoder("foo");
        ConstantValueEncoderTest.assertEquals((Object)"foo", (Object)enc.asString("123"));
    }
}

