/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.collocations.llr;

import com.google.common.collect.Maps;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.vectorizer.collocations.llr.Gram;
import org.junit.Test;

public final class GramTest
extends MahoutTestCase {
    @Test
    public void testConstructorsGetters() {
        Gram one = new Gram("foo", 2, Gram.Type.HEAD);
        GramTest.assertEquals((Object)"foo", (Object)one.getString());
        GramTest.assertEquals((long)2L, (long)one.getFrequency());
        GramTest.assertEquals((Object)Gram.Type.HEAD, (Object)one.getType());
        Gram oneClone = new Gram(one);
        GramTest.assertEquals((Object)"foo", (Object)oneClone.getString());
        GramTest.assertEquals((long)2L, (long)oneClone.getFrequency());
        GramTest.assertEquals((Object)Gram.Type.HEAD, (Object)oneClone.getType());
        Gram two = new Gram("foo", 3, Gram.Type.TAIL);
        GramTest.assertEquals((Object)Gram.Type.TAIL, (Object)two.getType());
        Gram three = new Gram("foo", 4, Gram.Type.UNIGRAM);
        GramTest.assertEquals((Object)Gram.Type.UNIGRAM, (Object)three.getType());
        Gram four = new Gram("foo", 5, Gram.Type.NGRAM);
        GramTest.assertEquals((Object)Gram.Type.NGRAM, (Object)four.getType());
    }

    @Test(expected=NullPointerException.class)
    public void testNull1() {
        new Gram(null, 4, Gram.Type.UNIGRAM);
    }

    @Test(expected=NullPointerException.class)
    public void testNull2() {
        new Gram("foo", 4, null);
    }

    @Test
    public void testEquality() {
        Gram one = new Gram("foo", 2, Gram.Type.HEAD);
        Gram two = new Gram("foo", 3, Gram.Type.HEAD);
        GramTest.assertEquals((Object)one, (Object)two);
        GramTest.assertEquals((Object)two, (Object)one);
        Gram three = new Gram("foo", 4, Gram.Type.TAIL);
        Gram four = new Gram("foo", Gram.Type.UNIGRAM);
        GramTest.assertTrue((!three.equals((Object)two) ? 1 : 0) != 0);
        GramTest.assertTrue((!four.equals((Object)one) ? 1 : 0) != 0);
        GramTest.assertTrue((!one.equals((Object)four) ? 1 : 0) != 0);
        Gram five = new Gram("foo", 5, Gram.Type.UNIGRAM);
        GramTest.assertEquals((Object)four, (Object)five);
        Gram six = new Gram("foo", 6, Gram.Type.NGRAM);
        Gram seven = new Gram("foo", 7, Gram.Type.NGRAM);
        GramTest.assertTrue((!five.equals((Object)six) ? 1 : 0) != 0);
        GramTest.assertEquals((Object)six, (Object)seven);
        Gram eight = new Gram("foobar", 4, Gram.Type.TAIL);
        GramTest.assertTrue((!eight.equals((Object)four) ? 1 : 0) != 0);
        GramTest.assertTrue((!eight.equals((Object)three) ? 1 : 0) != 0);
        GramTest.assertTrue((!eight.equals((Object)two) ? 1 : 0) != 0);
        GramTest.assertTrue((!eight.equals((Object)one) ? 1 : 0) != 0);
    }

    @Test
    public void testHashing() {
        Gram[] input = new Gram[]{new Gram("foo", 2, Gram.Type.HEAD), new Gram("foo", 3, Gram.Type.HEAD), new Gram("foo", 4, Gram.Type.TAIL), new Gram("foo", 5, Gram.Type.TAIL), new Gram("bar", 6, Gram.Type.HEAD), new Gram("bar", 7, Gram.Type.TAIL), new Gram("bar", 8, Gram.Type.NGRAM), new Gram("bar", Gram.Type.UNIGRAM)};
        HashMap map = Maps.newHashMap();
        for (Gram n : input) {
            Gram val = (Gram)map.get(n);
            if (val != null) {
                val.incrementFrequency(n.getFrequency());
                continue;
            }
            map.put(n, n);
        }
        int[] freq = new int[]{5, 3, 9, 5, 6, 7, 8, 1};
        boolean[] memb = new boolean[]{true, false, true, false, true, true, true, true};
        for (int i = 0; i < input.length; ++i) {
            GramTest.assertEquals((long)freq[i], (long)input[i].getFrequency());
            GramTest.assertEquals((Object)memb[i], (Object)(input[i] == map.get(input[i]) ? 1 : 0));
        }
    }

    @Test
    public void testWritable() throws Exception {
        Gram one = new Gram("foo", 2, Gram.Type.HEAD);
        Gram two = new Gram("foobar", 3, Gram.Type.UNIGRAM);
        GramTest.assertEquals((Object)"foo", (Object)one.getString());
        GramTest.assertEquals((long)2L, (long)one.getFrequency());
        GramTest.assertEquals((Object)Gram.Type.HEAD, (Object)one.getType());
        GramTest.assertEquals((Object)"foobar", (Object)two.getString());
        GramTest.assertEquals((long)3L, (long)two.getFrequency());
        GramTest.assertEquals((Object)Gram.Type.UNIGRAM, (Object)two.getType());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(bout);
        two.write((DataOutput)out);
        byte[] b = bout.toByteArray();
        ByteArrayInputStream bin = new ByteArrayInputStream(b);
        DataInputStream din = new DataInputStream(bin);
        one.readFields((DataInput)din);
        GramTest.assertEquals((Object)"foobar", (Object)one.getString());
        GramTest.assertEquals((long)3L, (long)one.getFrequency());
        GramTest.assertEquals((Object)Gram.Type.UNIGRAM, (Object)one.getType());
    }

    @Test
    public void testSorting() {
        Gram[] input = new Gram[]{new Gram("foo", 2, Gram.Type.HEAD), new Gram("foo", 3, Gram.Type.HEAD), new Gram("foo", 4, Gram.Type.TAIL), new Gram("foo", 5, Gram.Type.TAIL), new Gram("bar", 6, Gram.Type.HEAD), new Gram("bar", 7, Gram.Type.TAIL), new Gram("bar", 8, Gram.Type.NGRAM), new Gram("bar", Gram.Type.UNIGRAM)};
        Object[] sorted = new Gram[input.length];
        int[] expectations = new int[]{4, 0, 1, 5, 2, 3, 7, 6};
        System.arraycopy(input, 0, sorted, 0, input.length);
        Arrays.sort(sorted);
        for (int i = 0; i < sorted.length; ++i) {
            GramTest.assertSame((Object)input[expectations[i]], (Object)sorted[i]);
        }
    }
}

