/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd;

import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.apache.mahout.common.IOUtils;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.QRDecomposition;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.SingularValueDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.DoubleFunction;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.function.VectorFunction;
import org.apache.mahout.math.hadoop.stochasticsvd.LocalSSVDSolverSparseSequentialTest;
import org.apache.mahout.math.hadoop.stochasticsvd.Omega;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDCommonTest;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDHelper;
import org.apache.mahout.math.hadoop.stochasticsvd.SSVDSolver;
import org.junit.Test;

public class LocalSSVDPCASparseTest
extends MahoutTestCase {
    private static final double s_epsilon = 1.0E-10;

    @Test
    public void testOmegaTRightMultiply() {
        RandomWrapper rnd = RandomUtils.getRandom();
        long seed = rnd.nextLong();
        int n = 2000;
        int kp = 100;
        Omega omega = new Omega(seed, 100);
        DenseMatrix materializedOmega = new DenseMatrix(2000, 100);
        for (int i = 0; i < 2000; ++i) {
            for (int j = 0; j < 100; ++j) {
                materializedOmega.setQuick(i, j, omega.getQuick(i, j));
            }
        }
        DenseVector xi = new DenseVector(2000);
        xi.assign(new DoubleFunction((Random)rnd){
            final /* synthetic */ Random val$rnd;
            {
                this.val$rnd = random;
            }

            public double apply(double x) {
                return this.val$rnd.nextDouble() * 100.0;
            }
        });
        Vector s_o = omega.mutlithreadedTRightMultiply((Vector)xi);
        DenseMatrix xiVector = new DenseMatrix(2000, 1);
        xiVector.assignColumn(0, (Vector)xi);
        Vector s_o_control = materializedOmega.transpose().times((Matrix)xiVector).viewColumn(0);
        LocalSSVDPCASparseTest.assertEquals((double)0.0, (double)s_o.minus(s_o_control).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-10);
        System.out.printf("s_omega=\n%s\n", s_o);
        System.out.printf("s_omega_control=\n%s\n", s_o_control);
    }

    @Test
    public void runPCATest1() throws IOException {
        this.runSSVDSolver(1);
    }

    public void runPCATest0() throws IOException {
        this.runSSVDSolver(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runSSVDSolver(int q) throws IOException {
        Configuration conf = new Configuration();
        conf.set("mapred.job.tracker", "local");
        conf.set("fs.default.name", "file:///");
        LinkedList closeables = Lists.newLinkedList();
        try {
            RandomWrapper rnd = RandomUtils.getRandom();
            File tmpDir = this.getTestTempDir("svdtmp");
            conf.set("hadoop.tmp.dir", tmpDir.getAbsolutePath());
            Path aLocPath = new Path(this.getTestTempDirPath("svdtmp/A"), "A.seq");
            SequenceFile.Writer w = SequenceFile.createWriter((FileSystem)FileSystem.getLocal((Configuration)conf), (Configuration)conf, (Path)aLocPath, Text.class, VectorWritable.class, (SequenceFile.CompressionType)SequenceFile.CompressionType.BLOCK, (CompressionCodec)new DefaultCodec());
            closeables.addFirst(w);
            int n = 100;
            int m = 2000;
            double percent = 5.0;
            VectorWritable vw = new VectorWritable();
            Text rkey = new Text();
            DenseVector xi = new DenseVector(n);
            double muAmplitude = 50.0;
            for (int i = 0; i < m; ++i) {
                SequentialAccessSparseVector dv = new SequentialAccessSparseVector(n);
                String rowname = "row-" + i;
                NamedVector namedRow = new NamedVector((Vector)dv, rowname);
                int j = 0;
                while ((double)j < (double)n * percent / 100.0) {
                    dv.setQuick(rnd.nextInt(n), muAmplitude * (rnd.nextDouble() - 0.25));
                    ++j;
                }
                rkey.set("row-i" + i);
                vw.set((Vector)namedRow);
                w.append((Writable)rkey, (Writable)vw);
                xi.assign((Vector)dv, Functions.PLUS);
            }
            closeables.remove(w);
            Closeables.close((Closeable)w, (boolean)false);
            xi.assign(Functions.mult((double)(1.0 / (double)m)));
            FileSystem fs = FileSystem.get((Configuration)conf);
            Path tempDirPath = this.getTestTempDirPath("svd-proc");
            Path aPath = new Path(tempDirPath, "A/A.seq");
            fs.copyFromLocalFile(aLocPath, aPath);
            Path xiPath = new Path(tempDirPath, "xi/xi.seq");
            SSVDHelper.saveVector((Vector)xi, (Path)xiPath, (Configuration)conf);
            Path svdOutPath = new Path(tempDirPath, "SSVD-out");
            fs.delete(svdOutPath, true);
            System.out.println("Input prepared, starting solver...");
            int ablockRows = 867;
            int p = 60;
            int k = 40;
            SSVDSolver ssvd = new SSVDSolver(conf, new Path[]{aPath}, svdOutPath, ablockRows, k, p, 3);
            ssvd.setOuterBlockHeight(500);
            ssvd.setAbtBlockHeight(251);
            ssvd.setPcaMeanPath(xiPath);
            ssvd.setComputeU(false);
            ssvd.setComputeV(false);
            ssvd.setcUSigma(true);
            ssvd.setOverwrite(true);
            ssvd.setQ(q);
            ssvd.setBroadcast(true);
            ssvd.run();
            Vector stochasticSValues = ssvd.getSingularValues();
            DenseMatrix a = SSVDHelper.drmLoadAsDense((FileSystem)fs, (Path)aPath, (Configuration)conf);
            this.verifyInternals(svdOutPath, (Matrix)a, new Omega(ssvd.getOmegaSeed(), k + p), k + p, q);
            for (int i = 0; i < m; ++i) {
                a.viewRow(i).assign((Vector)xi, Functions.MINUS);
            }
            SingularValueDecomposition svd2 = new SingularValueDecomposition((Matrix)a);
            DenseVector svalues2 = new DenseVector(svd2.getSingularValues());
            System.out.println("--SSVD solver singular values:");
            LocalSSVDSolverSparseSequentialTest.dumpSv(stochasticSValues);
            System.out.println("--SVD solver singular values:");
            LocalSSVDSolverSparseSequentialTest.dumpSv((Vector)svalues2);
            for (int i = 0; i < k + p; ++i) {
                LocalSSVDPCASparseTest.assertTrue((Math.abs(svalues2.getQuick(i) - stochasticSValues.getQuick(i)) <= 1.0E-10 ? 1 : 0) != 0);
            }
            DenseMatrix mQ = SSVDHelper.drmLoadAsDense((FileSystem)fs, (Path)new Path(svdOutPath, "Bt-job/Q-*"), (Configuration)conf);
            SSVDCommonTest.assertOrthonormality((Matrix)mQ, false, 1.0E-10);
            Iterator iter = SSVDHelper.drmIterator((FileSystem)fs, (Path)new Path(ssvd.getuSigmaPath() + "/*"), (Configuration)conf, (Deque)closeables);
            while (iter.hasNext()) {
                Pair pair = (Pair)iter.next();
                Writable key = (Writable)pair.getFirst();
                Vector v = (Vector)pair.getSecond();
                LocalSSVDPCASparseTest.assertTrue((boolean)(v instanceof NamedVector));
                LocalSSVDPCASparseTest.assertTrue((boolean)(key instanceof Text));
            }
        }
        finally {
            IOUtils.close((Collection)closeables);
        }
    }

    private void verifyInternals(Path tempDir, Matrix a, Omega omega, int kp, int q) {
        int m = a.numRows();
        int n = a.numCols();
        Vector xi = a.aggregateColumns(new VectorFunction(){

            public double apply(Vector v) {
                return v.zSum() / (double)v.size();
            }
        });
        DenseMatrix momega = new DenseMatrix(n, kp);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < kp; ++j) {
                momega.setQuick(i, j, omega.getQuick(i, j));
            }
        }
        Vector s_o = omega.mutlithreadedTRightMultiply(xi);
        System.out.printf("s_omega=\n%s\n", s_o);
        Matrix y = a.times((Matrix)momega);
        for (int i = 0; i < n; ++i) {
            y.viewRow(i).assign(s_o, Functions.MINUS);
        }
        QRDecomposition qr = new QRDecomposition(y);
        Matrix qm = qr.getQ();
        Vector s_q = qm.aggregateColumns(new VectorFunction(){

            public double apply(Vector v) {
                return v.zSum();
            }
        });
        System.out.printf("s_q=\n%s\n", s_q);
        Matrix b = qm.transpose().times(a);
        Vector s_b = b.times(xi);
        System.out.printf("s_b=\n%s\n", s_b);
    }
}

