/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.distance;

import org.apache.mahout.common.distance.DefaultDistanceMeasureTest;
import org.apache.mahout.common.distance.WeightedDistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public abstract class DefaultWeightedDistanceMeasureTest
extends DefaultDistanceMeasureTest {
    public abstract WeightedDistanceMeasure distanceMeasureFactory();

    @Test
    public void testMeasureWeighted() {
        WeightedDistanceMeasure distanceMeasure = this.distanceMeasureFactory();
        Vector[] vectors = new Vector[]{new DenseVector(new double[]{9.0, 9.0, 1.0}), new DenseVector(new double[]{1.0, 9.0, 9.0}), new DenseVector(new double[]{9.0, 1.0, 9.0})};
        distanceMeasure.setWeights((Vector)new DenseVector(new double[]{1.0, 1000.0, 1.0}));
        double[][] distanceMatrix = new double[3][3];
        for (int a = 0; a < 3; ++a) {
            for (int b = 0; b < 3; ++b) {
                distanceMatrix[a][b] = distanceMeasure.distance(vectors[a], vectors[b]);
            }
        }
        DefaultWeightedDistanceMeasureTest.assertEquals((double)0.0, (double)distanceMatrix[0][0], (double)1.0E-6);
        DefaultWeightedDistanceMeasureTest.assertTrue((distanceMatrix[0][1] < distanceMatrix[0][2] ? 1 : 0) != 0);
    }
}

