/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.cli2.Option;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.junit.Assert;
import org.junit.Test;

public final class AbstractJobTest
extends MahoutTestCase {
    @Test
    public void testFlag() throws Exception {
        final HashMap testMap = Maps.newHashMap();
        AbstractJobFactory fact = new AbstractJobFactory(){

            @Override
            public AbstractJob getJob() {
                return new AbstractJob(){

                    public int run(String[] args) throws IOException {
                        this.addFlag("testFlag", "t", "a simple test flag");
                        Map argMap = this.parseArguments(args);
                        testMap.clear();
                        testMap.putAll(argMap);
                        return 1;
                    }
                };
            }
        };
        ToolRunner.run((Tool)fact.getJob(), (String[])new String[0]);
        AbstractJobTest.assertFalse((String)"test map for absent flag", (boolean)testMap.containsKey("--testFlag"));
        String[] withFlag = new String[]{"--testFlag"};
        ToolRunner.run((Tool)fact.getJob(), (String[])withFlag);
        AbstractJobTest.assertTrue((String)"test map for present flag", (boolean)testMap.containsKey("--testFlag"));
    }

    @Test
    public void testOptions() throws Exception {
        final HashMap testMap = Maps.newHashMap();
        AbstractJobFactory fact = new AbstractJobFactory(){

            @Override
            public AbstractJob getJob() {
                return new AbstractJob(){

                    public int run(String[] args) throws IOException {
                        this.addOption((Option)DefaultOptionCreator.overwriteOption().create());
                        this.addOption("option", "o", "option");
                        this.addOption("required", "r", "required", true);
                        this.addOption("notRequired", "nr", "not required", false);
                        this.addOption("hasDefault", "hd", "option w/ default", "defaultValue");
                        Map argMap = this.parseArguments(args);
                        if (argMap == null) {
                            return -1;
                        }
                        testMap.clear();
                        testMap.putAll(argMap);
                        return 0;
                    }
                };
            }
        };
        int ret = ToolRunner.run((Tool)fact.getJob(), (String[])new String[0]);
        AbstractJobTest.assertEquals((String)"-1 for missing required options", (long)-1L, (long)ret);
        ret = ToolRunner.run((Tool)fact.getJob(), (String[])new String[]{"--required", "requiredArg"});
        AbstractJobTest.assertEquals((String)"0 for no missing required options", (long)0L, (long)ret);
        AbstractJobTest.assertEquals(Collections.singletonList("requiredArg"), testMap.get("--required"));
        AbstractJobTest.assertEquals(Collections.singletonList("defaultValue"), testMap.get("--hasDefault"));
        AbstractJobTest.assertNull(testMap.get("--option"));
        AbstractJobTest.assertNull(testMap.get("--notRequired"));
        AbstractJobTest.assertFalse((boolean)testMap.containsKey("--overwrite"));
        ret = ToolRunner.run((Tool)fact.getJob(), (String[])new String[]{"--required", "requiredArg", "--unknownArg"});
        AbstractJobTest.assertEquals((String)"-1 for including unknown options", (long)-1L, (long)ret);
        ret = ToolRunner.run((Tool)fact.getJob(), (String[])new String[]{"--required", "requiredArg", "--required", "requiredArg2"});
        AbstractJobTest.assertEquals((String)"-1 for including duplicate options", (long)-1L, (long)ret);
        ret = ToolRunner.run((Tool)fact.getJob(), (String[])new String[]{"--required", "requiredArg", "--overwrite", "--hasDefault", "nonDefault", "--option", "optionValue", "--notRequired", "notRequired"});
        AbstractJobTest.assertEquals((String)"0 for no missing required options", (long)0L, (long)ret);
        AbstractJobTest.assertEquals(Collections.singletonList("requiredArg"), testMap.get("--required"));
        AbstractJobTest.assertEquals(Collections.singletonList("nonDefault"), testMap.get("--hasDefault"));
        AbstractJobTest.assertEquals(Collections.singletonList("optionValue"), testMap.get("--option"));
        AbstractJobTest.assertEquals(Collections.singletonList("notRequired"), testMap.get("--notRequired"));
        AbstractJobTest.assertTrue((boolean)testMap.containsKey("--overwrite"));
        ret = ToolRunner.run((Tool)fact.getJob(), (String[])new String[]{"-r", "requiredArg", "-ow", "-hd", "nonDefault", "-o", "optionValue", "-nr", "notRequired"});
        AbstractJobTest.assertEquals((String)"0 for no missing required options", (long)0L, (long)ret);
        AbstractJobTest.assertEquals(Collections.singletonList("requiredArg"), testMap.get("--required"));
        AbstractJobTest.assertEquals(Collections.singletonList("nonDefault"), testMap.get("--hasDefault"));
        AbstractJobTest.assertEquals(Collections.singletonList("optionValue"), testMap.get("--option"));
        AbstractJobTest.assertEquals(Collections.singletonList("notRequired"), testMap.get("--notRequired"));
        AbstractJobTest.assertTrue((boolean)testMap.containsKey("--overwrite"));
    }

    @Test
    public void testInputOutputPaths() throws Exception {
        AbstractJobFactory fact = new AbstractJobFactory(){

            @Override
            public AbstractJob getJob() {
                return new AbstractJob(){

                    public int run(String[] args) throws IOException {
                        this.addInputOption();
                        this.addOutputOption();
                        Map argMap = this.parseArguments(args);
                        if (argMap == null) {
                            return -1;
                        }
                        Path inputPath = this.getInputPath();
                        Assert.assertNotNull((String)"getInputPath() returns non-null", (Object)inputPath);
                        Path outputPath = this.getInputPath();
                        Assert.assertNotNull((String)"getOutputPath() returns non-null", (Object)outputPath);
                        return 0;
                    }
                };
            }
        };
        int ret = ToolRunner.run((Tool)fact.getJob(), (String[])new String[0]);
        AbstractJobTest.assertEquals((String)"-1 for missing input option", (long)-1L, (long)ret);
        String testInputPath = "testInputPath";
        AbstractJob job = fact.getJob();
        ret = ToolRunner.run((Tool)job, (String[])new String[]{"--input", testInputPath});
        AbstractJobTest.assertEquals((String)"-1 for missing output option", (long)-1L, (long)ret);
        AbstractJobTest.assertEquals((String)"input path is correct", (Object)testInputPath, (Object)job.getInputPath().toString());
        job = fact.getJob();
        String testOutputPath = "testOutputPath";
        ret = ToolRunner.run((Tool)job, (String[])new String[]{"--output", testOutputPath});
        AbstractJobTest.assertEquals((String)"-1 for missing input option", (long)-1L, (long)ret);
        AbstractJobTest.assertEquals((String)"output path is correct", (Object)testOutputPath, (Object)job.getOutputPath().toString());
        job = fact.getJob();
        ret = ToolRunner.run((Tool)job, (String[])new String[]{"--input", testInputPath, "--output", testOutputPath});
        AbstractJobTest.assertEquals((String)"0 for complete options", (long)0L, (long)ret);
        AbstractJobTest.assertEquals((String)"input path is correct", (Object)testInputPath, (Object)job.getInputPath().toString());
        AbstractJobTest.assertEquals((String)"output path is correct", (Object)testOutputPath, (Object)job.getOutputPath().toString());
        job = fact.getJob();
        ret = ToolRunner.run((Tool)job, (String[])new String[]{"--input", testInputPath, "--output", testOutputPath});
        AbstractJobTest.assertEquals((String)"0 for complete options", (long)0L, (long)ret);
        AbstractJobTest.assertEquals((String)"input path is correct", (Object)testInputPath, (Object)job.getInputPath().toString());
        AbstractJobTest.assertEquals((String)"output path is correct", (Object)testOutputPath, (Object)job.getOutputPath().toString());
        job = fact.getJob();
        String testInputPropertyPath = "testInputPropertyPath";
        String testOutputPropertyPath = "testOutputPropertyPath";
        ret = ToolRunner.run((Tool)job, (String[])new String[]{"-Dmapred.input.dir=" + testInputPropertyPath, "-Dmapred.output.dir=" + testOutputPropertyPath});
        AbstractJobTest.assertEquals((String)"0 for complete options", (long)0L, (long)ret);
        AbstractJobTest.assertEquals((String)"input path from property is correct", (Object)testInputPropertyPath, (Object)job.getInputPath().toString());
        AbstractJobTest.assertEquals((String)"output path from property is correct", (Object)testOutputPropertyPath, (Object)job.getOutputPath().toString());
        job = fact.getJob();
        ret = ToolRunner.run((Tool)job, (String[])new String[]{"-Dmapred.input.dir=" + testInputPropertyPath, "-Dmapred.output.dir=" + testOutputPropertyPath, "--input", testInputPath, "--output", testOutputPath});
        AbstractJobTest.assertEquals((String)"0 for complete options", (long)0L, (long)ret);
        AbstractJobTest.assertEquals((String)"input command-line option precedes property", (Object)testInputPath, (Object)job.getInputPath().toString());
        AbstractJobTest.assertEquals((String)"output command-line option precedes property", (Object)testOutputPath, (Object)job.getOutputPath().toString());
    }

    static interface AbstractJobFactory {
        public AbstractJob getJob();
    }
}

