/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.spectral.VectorCache;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.junit.Test;

public class TestVectorCache
extends MahoutTestCase {
    private static final double[] VECTOR = new double[]{1.0, 2.0, 3.0, 4.0};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSave() throws Exception {
        Configuration conf = this.getConfiguration();
        IntWritable key = new IntWritable(0);
        DenseVector value = new DenseVector(VECTOR);
        Path path = this.getTestTempDirPath("output");
        VectorCache.save((Writable)key, (Vector)value, (Path)path, (Configuration)conf, (boolean)true, (boolean)true);
        SequenceFileValueIterator iterator = new SequenceFileValueIterator(path, true, conf);
        try {
            VectorWritable old = (VectorWritable)iterator.next();
            TestVectorCache.assertEquals((String)"Saved vector is identical to original", (Object)old.get(), (Object)value);
        }
        finally {
            Closeables.close((Closeable)iterator, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoad() throws Exception {
        Configuration conf = this.getConfiguration();
        IntWritable key = new IntWritable(0);
        DenseVector value = new DenseVector(VECTOR);
        Path path = this.getTestTempDirPath("output");
        FileSystem fs = FileSystem.get((URI)path.toUri(), (Configuration)conf);
        path = fs.makeQualified(path);
        fs.deleteOnExit(path);
        HadoopUtil.delete((Configuration)conf, (Path[])new Path[]{path});
        SequenceFile.Writer writer = new SequenceFile.Writer(fs, conf, path, IntWritable.class, VectorWritable.class);
        try {
            writer.append((Writable)key, (Writable)new VectorWritable((Vector)value));
        }
        finally {
            Closeables.close((Closeable)writer, (boolean)false);
        }
        DistributedCache.setCacheFiles((URI[])new URI[]{path.toUri()}, (Configuration)conf);
        Vector result = VectorCache.load((Configuration)conf);
        TestVectorCache.assertNotNull((String)"Vector is null", (Object)result);
        TestVectorCache.assertEquals((String)"Loaded vector is not identical to original", (Object)result, (Object)value);
    }

    @Test
    public void testAll() throws Exception {
        Configuration conf = this.getConfiguration();
        DenseVector v = new DenseVector(VECTOR);
        Path toSave = this.getTestTempDirPath("output");
        IntWritable key = new IntWritable(0);
        VectorCache.save((Writable)key, (Vector)v, (Path)toSave, (Configuration)conf);
        Vector v2 = VectorCache.load((Configuration)conf);
        TestVectorCache.assertNotNull((String)"Vector is null", (Object)v2);
        TestVectorCache.assertEquals((String)"Vectors are not identical", (Object)v2, (Object)v);
    }
}

