/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering;

import org.apache.mahout.clustering.kmeans.Kluster;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.junit.Test;

public final class TestClusterInterface
extends MahoutTestCase {
    private static final DistanceMeasure measure = new ManhattanDistanceMeasure();

    @Test
    public void testClusterAsFormatString() {
        double[] d = new double[]{1.1, 2.2, 3.3};
        DenseVector m = new DenseVector(d);
        Kluster cluster = new Kluster((Vector)m, 123, measure);
        String formatString = cluster.asFormatString(null);
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"r\":[]"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"c\":[1.1,2.2,3.3]"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"n\":0"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"identifier\":\"CL-123\""));
    }

    @Test
    public void testClusterAsFormatStringSparse() {
        double[] d = new double[]{1.1, 0.0, 3.3};
        SequentialAccessSparseVector m = new SequentialAccessSparseVector(3);
        m.assign(d);
        Kluster cluster = new Kluster((Vector)m, 123, measure);
        String formatString = cluster.asFormatString(null);
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"r\":[]"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"c\":[{\"0\":1.1},{\"2\":3.3}]"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"n\":0"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"identifier\":\"CL-123\""));
    }

    @Test
    public void testClusterAsFormatStringWithBindings() {
        double[] d = new double[]{1.1, 2.2, 3.3};
        DenseVector m = new DenseVector(d);
        Kluster cluster = new Kluster((Vector)m, 123, measure);
        String[] bindings = new String[]{"fee", null, "foo"};
        String formatString = cluster.asFormatString(bindings);
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"r\":[]"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"c\":[{\"fee\":1.1},{\"1\":2.2},{\"foo\":3.3}]"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"n\":0"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"identifier\":\"CL-123\""));
    }

    @Test
    public void testClusterAsFormatStringSparseWithBindings() {
        double[] d = new double[]{1.1, 0.0, 3.3};
        SequentialAccessSparseVector m = new SequentialAccessSparseVector(3);
        m.assign(d);
        Kluster cluster = new Kluster((Vector)m, 123, measure);
        String formatString = cluster.asFormatString(null);
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"r\":[]"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"c\":[{\"0\":1.1},{\"2\":3.3}]"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"n\":0"));
        TestClusterInterface.assertTrue((boolean)formatString.contains("\"identifier\":\"CL-123\""));
    }
}

