/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.tools;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Random;
import org.apache.mahout.classifier.df.DecisionForest;
import org.apache.mahout.classifier.df.builder.DecisionTreeBuilder;
import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.DataLoader;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.Instance;
import org.apache.mahout.classifier.df.node.CategoricalNode;
import org.apache.mahout.classifier.df.node.Leaf;
import org.apache.mahout.classifier.df.node.Node;
import org.apache.mahout.classifier.df.node.NumericalNode;
import org.apache.mahout.classifier.df.tools.ForestVisualizer;
import org.apache.mahout.classifier.df.tools.TreeVisualizer;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class VisualizerTest
extends MahoutTestCase {
    private static final char DECIMAL_SEPARATOR = ((DecimalFormat)DecimalFormat.getInstance()).getDecimalFormatSymbols().getDecimalSeparator();
    private static final String[] TRAIN_DATA = new String[]{"sunny,85,85,FALSE,no", "sunny,80,90,TRUE,no", "overcast,83,86,FALSE,yes", "rainy,70,96,FALSE,yes", "rainy,68,80,FALSE,yes", "rainy,65,70,TRUE,no", "overcast,64,65,TRUE,yes", "sunny,72,95,FALSE,no", "sunny,69,70,FALSE,yes", "rainy,75,80,FALSE,yes", "sunny,75,70,TRUE,yes", "overcast,72,90,TRUE,yes", "overcast,81,75,FALSE,yes", "rainy,71,91,TRUE,no"};
    private static final String[] TEST_DATA = new String[]{"rainy,70,96,TRUE,-", "overcast,64,65,TRUE,-", "sunny,75,90,TRUE,-"};
    private static final String[] ATTRIBUTE_NAMES = new String[]{"outlook", "temperature", "humidity", "windy", "play"};
    private Random randomNumberGenerator;
    private Data trainingData;
    private Data testData;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.randomNumberGenerator = RandomUtils.getRandom((long)1L);
        Dataset dataset = DataLoader.generateDataset((CharSequence)"C N N C L", (boolean)false, (String[])TRAIN_DATA);
        this.trainingData = DataLoader.loadData((Dataset)dataset, (String[])TRAIN_DATA);
        this.testData = DataLoader.loadData((Dataset)dataset, (String[])TEST_DATA);
    }

    @Test
    public void testTreeVisualize() throws Exception {
        DecisionTreeBuilder builder = new DecisionTreeBuilder();
        builder.setM(this.trainingData.getDataset().nbAttributes() - 1);
        Node tree = builder.build(this.randomNumberGenerator, this.trainingData);
        String visualization = TreeVisualizer.toString((Node)tree, (Dataset)this.trainingData.getDataset(), (String[])ATTRIBUTE_NAMES);
        VisualizerTest.assertTrue((String.format("\noutlook = rainy\n|   windy = FALSE : yes\n|   windy = TRUE : no\noutlook = sunny\n|   humidity < 77%s5 : yes\n|   humidity >= 77%s5 : no\noutlook = overcast : yes", Character.valueOf(DECIMAL_SEPARATOR), Character.valueOf(DECIMAL_SEPARATOR)).equals(visualization) || String.format("\noutlook = rainy\n|   windy = TRUE : no\n|   windy = FALSE : yes\noutlook = overcast : yes\noutlook = sunny\n|   humidity < 77%s5 : yes\n|   humidity >= 77%s5 : no", Character.valueOf(DECIMAL_SEPARATOR), Character.valueOf(DECIMAL_SEPARATOR)).equals(visualization) ? 1 : 0) != 0);
    }

    @Test
    public void testPredictTrace() throws Exception {
        DecisionTreeBuilder builder = new DecisionTreeBuilder();
        builder.setM(this.trainingData.getDataset().nbAttributes() - 1);
        Node tree = builder.build(this.randomNumberGenerator, this.trainingData);
        Object[] prediction = TreeVisualizer.predictTrace((Node)tree, (Data)this.testData, (String[])ATTRIBUTE_NAMES);
        Assert.assertArrayEquals((Object[])new String[]{"outlook = rainy -> windy = TRUE -> no", "outlook = overcast -> yes", String.format("outlook = sunny -> (humidity = 90) >= 77%s5 -> no", Character.valueOf(DECIMAL_SEPARATOR))}, (Object[])prediction);
    }

    @Test
    public void testForestVisualize() throws Exception {
        NumericalNode root = new NumericalNode(2, 90.0, (Node)new Leaf(0.0), (Node)new CategoricalNode(0, new double[]{0.0, 1.0, 2.0}, new Node[]{new NumericalNode(1, 71.0, (Node)new Leaf(0.0), (Node)new Leaf(1.0)), new Leaf(1.0), new Leaf(0.0)}));
        ArrayList<NumericalNode> trees = new ArrayList<NumericalNode>();
        trees.add(root);
        DecisionForest forest = new DecisionForest(trees);
        String visualization = ForestVisualizer.toString((DecisionForest)forest, (Dataset)this.trainingData.getDataset(), null);
        VisualizerTest.assertTrue(("Tree[1]:\n2 < 90 : yes\n2 >= 90\n|   0 = rainy\n|   |   1 < 71 : yes\n|   |   1 >= 71 : no\n|   0 = sunny : no\n|   0 = overcast : yes\n".equals(visualization) || "Tree[1]:\n2 < 90 : no\n2 >= 90\n|   0 = rainy\n|   |   1 < 71 : no\n|   |   1 >= 71 : yes\n|   0 = overcast : yes\n|   0 = sunny : no\n".equals(visualization) ? 1 : 0) != 0);
        visualization = ForestVisualizer.toString((DecisionForest)forest, (Dataset)this.trainingData.getDataset(), (String[])ATTRIBUTE_NAMES);
        VisualizerTest.assertTrue(("Tree[1]:\nhumidity < 90 : yes\nhumidity >= 90\n|   outlook = rainy\n|   |   temperature < 71 : yes\n|   |   temperature >= 71 : no\n|   outlook = sunny : no\n|   outlook = overcast : yes\n".equals(visualization) || "Tree[1]:\nhumidity < 90 : no\nhumidity >= 90\n|   outlook = rainy\n|   |   temperature < 71 : no\n|   |   temperature >= 71 : yes\n|   outlook = overcast : yes\n|   outlook = sunny : no\n".equals(visualization) ? 1 : 0) != 0);
    }

    @Test
    public void testLeafless() throws Exception {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (int i = 0; i < this.trainingData.size(); ++i) {
            if (this.trainingData.get(i).get(0) == 0.0) continue;
            instances.add(this.trainingData.get(i));
        }
        Data lessData = new Data(this.trainingData.getDataset(), instances);
        DecisionTreeBuilder builder = new DecisionTreeBuilder();
        builder.setM(this.trainingData.getDataset().nbAttributes() - 1);
        builder.setMinSplitNum(0);
        builder.setComplemented(false);
        Node tree = builder.build(this.randomNumberGenerator, lessData);
        String visualization = TreeVisualizer.toString((Node)tree, (Dataset)this.trainingData.getDataset(), (String[])ATTRIBUTE_NAMES);
        VisualizerTest.assertTrue((String.format("\noutlook = sunny\n|   humidity < 77%s5 : yes\n|   humidity >= 77%s5 : no\noutlook = overcast : yes", Character.valueOf(DECIMAL_SEPARATOR), Character.valueOf(DECIMAL_SEPARATOR)).equals(visualization) || String.format("\noutlook = overcast : yes\noutlook = sunny\n|   humidity < 77%s5 : yes\n|   humidity >= 77%s5 : no", Character.valueOf(DECIMAL_SEPARATOR), Character.valueOf(DECIMAL_SEPARATOR)).equals(visualization) ? 1 : 0) != 0);
    }

    @Test
    public void testEmpty() throws Exception {
        Data emptyData = new Data(this.trainingData.getDataset());
        DecisionTreeBuilder builder = new DecisionTreeBuilder();
        Node tree = builder.build(this.randomNumberGenerator, emptyData);
        VisualizerTest.assertEquals((Object)" : unknown", (Object)TreeVisualizer.toString((Node)tree, (Dataset)this.trainingData.getDataset(), (String[])ATTRIBUTE_NAMES));
    }
}

