/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.split;

import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.DataLoader;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.DescriptorException;
import org.apache.mahout.classifier.df.data.conditions.Condition;
import org.apache.mahout.classifier.df.split.RegressionSplit;
import org.apache.mahout.classifier.df.split.Split;
import org.apache.mahout.common.MahoutTestCase;
import org.junit.Test;

public final class RegressionSplitTest
extends MahoutTestCase {
    private static Data[] generateTrainingData() throws DescriptorException {
        int i;
        String[] trainData = new String[20];
        for (int i2 = 0; i2 < trainData.length; ++i2) {
            trainData[i2] = i2 % 3 == 0 ? "A," + (40 - i2) + ',' + (i2 + 20) : (i2 % 3 == 1 ? "B," + (i2 + 20) + ',' + (40 - i2) : "C," + (i2 + 20) + ',' + (i2 + 20));
        }
        Dataset dataset = DataLoader.generateDataset((CharSequence)"C N L", (boolean)true, (String[])trainData);
        Data[] datas = new Data[3];
        datas[0] = DataLoader.loadData((Dataset)dataset, (String[])trainData);
        trainData = new String[20];
        for (i = 0; i < trainData.length; ++i) {
            trainData[i] = i % 2 == 0 ? "A," + (50 - i) + ',' + (i + 10) : "B," + (i + 10) + ',' + (50 - i);
        }
        datas[1] = DataLoader.loadData((Dataset)dataset, (String[])trainData);
        trainData = new String[10];
        for (i = 0; i < trainData.length; ++i) {
            trainData[i] = "A," + (40 - i) + ',' + (i + 20);
        }
        datas[2] = DataLoader.loadData((Dataset)dataset, (String[])trainData);
        return datas;
    }

    @Test
    public void testComputeSplit() throws DescriptorException {
        Data[] datas = RegressionSplitTest.generateTrainingData();
        RegressionSplit igSplit = new RegressionSplit();
        Split split = igSplit.computeSplit(datas[0], 1);
        RegressionSplitTest.assertEquals((double)180.0, (double)split.getIg(), (double)1.0E-6);
        RegressionSplitTest.assertEquals((double)38.0, (double)split.getSplit(), (double)1.0E-6);
        split = igSplit.computeSplit(datas[0].subset(Condition.lesser((int)1, (double)38.0)), 1);
        RegressionSplitTest.assertEquals((double)76.5, (double)split.getIg(), (double)1.0E-6);
        RegressionSplitTest.assertEquals((double)21.5, (double)split.getSplit(), (double)1.0E-6);
        split = igSplit.computeSplit(datas[1], 0);
        RegressionSplitTest.assertEquals((double)2205.0, (double)split.getIg(), (double)1.0E-6);
        RegressionSplitTest.assertEquals((double)Double.NaN, (double)split.getSplit(), (double)1.0E-6);
        split = igSplit.computeSplit(datas[1].subset(Condition.equals((int)0, (double)0.0)), 1);
        RegressionSplitTest.assertEquals((double)250.0, (double)split.getIg(), (double)1.0E-6);
        RegressionSplitTest.assertEquals((double)41.0, (double)split.getSplit(), (double)1.0E-6);
    }
}

