/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.split;

import java.util.Random;
import org.apache.mahout.classifier.df.data.Data;
import org.apache.mahout.classifier.df.data.DataLoader;
import org.apache.mahout.classifier.df.data.Dataset;
import org.apache.mahout.classifier.df.data.Utils;
import org.apache.mahout.classifier.df.split.DefaultIgSplit;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.junit.Test;

public final class DefaultIgSplitTest
extends MahoutTestCase {
    private static final int NUM_ATTRIBUTES = 10;

    @Test
    public void testEntropy() throws Exception {
        int index;
        RandomWrapper rng = RandomUtils.getRandom();
        String descriptor = Utils.randomDescriptor((Random)rng, 10);
        int label = Utils.findLabel(descriptor);
        double[][] temp = Utils.randomDoublesWithSameLabel((Random)rng, descriptor, false, 100, 0);
        String[] sData = Utils.double2String(temp);
        Dataset dataset = DataLoader.generateDataset((CharSequence)descriptor, (boolean)false, (String[])sData);
        Data data = DataLoader.loadData((Dataset)dataset, (String[])sData);
        DefaultIgSplit iG = new DefaultIgSplit();
        double expected = 0.0 - 1.0 * Math.log(1.0) / Math.log(2.0);
        DefaultIgSplitTest.assertEquals((double)expected, (double)iG.entropy(data), (double)1.0E-6);
        for (index = 0; index < 50; ++index) {
            temp[index][label] = 1.0;
        }
        sData = Utils.double2String(temp);
        dataset = DataLoader.generateDataset((CharSequence)descriptor, (boolean)false, (String[])sData);
        data = DataLoader.loadData((Dataset)dataset, (String[])sData);
        iG = new DefaultIgSplit();
        expected = -1.0 * Math.log(0.5) / Math.log(2.0);
        DefaultIgSplitTest.assertEquals((double)expected, (double)iG.entropy(data), (double)1.0E-6);
        for (index = 0; index < 15; ++index) {
            temp[index][label] = 2.0;
        }
        sData = Utils.double2String(temp);
        dataset = DataLoader.generateDataset((CharSequence)descriptor, (boolean)false, (String[])sData);
        data = DataLoader.loadData((Dataset)dataset, (String[])sData);
        iG = new DefaultIgSplit();
        expected = -0.15 * Math.log(0.15) / Math.log(2.0) - 0.35 * Math.log(0.35) / Math.log(2.0) - 0.5 * Math.log(0.5) / Math.log(2.0);
        DefaultIgSplitTest.assertEquals((double)expected, (double)iG.entropy(data), (double)1.0E-6);
    }
}

