/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.df.mapreduce.inmem;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Random;
import org.apache.mahout.classifier.df.mapreduce.inmem.InMemInputFormat;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.RandomUtils;
import org.junit.Before;
import org.junit.Test;

public final class InMemInputSplitTest
extends MahoutTestCase {
    private Random rng;
    private ByteArrayOutputStream byteOutStream;
    private DataOutput out;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rng = RandomUtils.getRandom();
        this.byteOutStream = new ByteArrayOutputStream();
        this.out = new DataOutputStream(this.byteOutStream);
    }

    @Test
    public void testWritable() throws Exception {
        InMemInputFormat.InMemInputSplit split = new InMemInputFormat.InMemInputSplit(this.rng.nextInt(), this.rng.nextInt(1000), Long.valueOf(this.rng.nextLong()));
        split.write(this.out);
        InMemInputSplitTest.assertEquals((Object)split, (Object)this.readSplit());
    }

    @Test
    public void testNullSeed() throws Exception {
        InMemInputFormat.InMemInputSplit split = new InMemInputFormat.InMemInputSplit(this.rng.nextInt(), this.rng.nextInt(1000), null);
        split.write(this.out);
        InMemInputSplitTest.assertEquals((Object)split, (Object)this.readSplit());
    }

    private InMemInputFormat.InMemInputSplit readSplit() throws IOException {
        ByteArrayInputStream byteInStream = new ByteArrayInputStream(this.byteOutStream.toByteArray());
        DataInputStream in = new DataInputStream(byteInStream);
        return InMemInputFormat.InMemInputSplit.read((DataInput)in);
    }
}

