/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveArrayIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.recommender.TopItems;
import org.apache.mahout.cf.taste.impl.similarity.GenericItemSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.GenericUserSimilarity;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.junit.Test;

public final class TopItemsTest
extends TasteTestCase {
    @Test
    public void testTopItems() throws Exception {
        long[] ids = new long[100];
        for (int i = 0; i < 100; ++i) {
            ids[i] = i;
        }
        LongPrimitiveArrayIterator possibleItemIds = new LongPrimitiveArrayIterator(ids);
        TopItems.Estimator<Long> estimator = new TopItems.Estimator<Long>(){

            public double estimate(Long thing) {
                return thing.longValue();
            }
        };
        List topItems = TopItems.getTopItems((int)10, (LongPrimitiveIterator)possibleItemIds, null, (TopItems.Estimator)estimator);
        int gold = 99;
        for (RecommendedItem topItem : topItems) {
            TopItemsTest.assertEquals((long)gold, (long)topItem.getItemID());
            TopItemsTest.assertEquals((double)gold--, (double)topItem.getValue(), (double)0.01);
        }
    }

    @Test
    public void testTopItemsRandom() throws Exception {
        long[] ids = new long[100];
        for (int i = 0; i < 100; ++i) {
            ids[i] = i;
        }
        LongPrimitiveArrayIterator possibleItemIds = new LongPrimitiveArrayIterator(ids);
        RandomWrapper random = RandomUtils.getRandom();
        TopItems.Estimator<Long> estimator = new TopItems.Estimator<Long>((Random)random){
            final /* synthetic */ Random val$random;
            {
                this.val$random = random;
            }

            public double estimate(Long thing) {
                return this.val$random.nextDouble();
            }
        };
        List topItems = TopItems.getTopItems((int)10, (LongPrimitiveIterator)possibleItemIds, null, (TopItems.Estimator)estimator);
        TopItemsTest.assertEquals((long)10L, (long)topItems.size());
        double last = 2.0;
        for (RecommendedItem topItem : topItems) {
            TopItemsTest.assertTrue(((double)topItem.getValue() <= last ? 1 : 0) != 0);
            last = topItem.getItemID();
        }
    }

    @Test
    public void testTopUsers() throws Exception {
        long[] ids = new long[100];
        for (int i = 0; i < 100; ++i) {
            ids[i] = i;
        }
        LongPrimitiveArrayIterator possibleItemIds = new LongPrimitiveArrayIterator(ids);
        TopItems.Estimator<Long> estimator = new TopItems.Estimator<Long>(){

            public double estimate(Long thing) {
                return thing.longValue();
            }
        };
        long[] topItems = TopItems.getTopUsers((int)10, (LongPrimitiveIterator)possibleItemIds, null, (TopItems.Estimator)estimator);
        int gold = 99;
        for (long topItem : topItems) {
            TopItemsTest.assertEquals((long)gold--, (long)topItem);
        }
    }

    @Test
    public void testTopItemItem() throws Exception {
        ArrayList sims = Lists.newArrayList();
        for (int i = 0; i < 99; ++i) {
            sims.add(new GenericItemSimilarity.ItemItemSimilarity((long)i, (long)(i + 1), (double)i / 99.0));
        }
        List res = TopItems.getTopItemItemSimilarities((int)10, sims.iterator());
        int gold = 99;
        for (GenericItemSimilarity.ItemItemSimilarity re : res) {
            TopItemsTest.assertEquals((long)gold--, (long)re.getItemID2());
        }
    }

    @Test
    public void testTopItemItemAlt() throws Exception {
        ArrayList sims = Lists.newArrayList();
        for (int i = 0; i < 99; ++i) {
            sims.add(new GenericItemSimilarity.ItemItemSimilarity((long)i, (long)(i + 1), 1.0 - (double)i / 99.0));
        }
        List res = TopItems.getTopItemItemSimilarities((int)10, sims.iterator());
        int gold = 0;
        for (GenericItemSimilarity.ItemItemSimilarity re : res) {
            TopItemsTest.assertEquals((long)gold++, (long)re.getItemID1());
        }
    }

    @Test
    public void testTopUserUser() throws Exception {
        ArrayList sims = Lists.newArrayList();
        for (int i = 0; i < 99; ++i) {
            sims.add(new GenericUserSimilarity.UserUserSimilarity((long)i, (long)(i + 1), (double)i / 99.0));
        }
        List res = TopItems.getTopUserUserSimilarities((int)10, sims.iterator());
        int gold = 99;
        for (GenericUserSimilarity.UserUserSimilarity re : res) {
            TopItemsTest.assertEquals((long)gold--, (long)re.getUserID2());
        }
    }

    @Test
    public void testTopUserUserAlt() throws Exception {
        ArrayList sims = Lists.newArrayList();
        for (int i = 0; i < 99; ++i) {
            sims.add(new GenericUserSimilarity.UserUserSimilarity((long)i, (long)(i + 1), 1.0 - (double)i / 99.0));
        }
        List res = TopItems.getTopUserUserSimilarities((int)10, sims.iterator());
        int gold = 0;
        for (GenericUserSimilarity.UserUserSimilarity re : res) {
            TopItemsTest.assertEquals((long)gold++, (long)re.getUserID1());
        }
    }
}

