/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.model.GenericItemPreferenceArray;
import org.apache.mahout.cf.taste.impl.model.GenericPreference;
import org.apache.mahout.cf.taste.impl.model.GenericUserPreferenceArray;
import org.apache.mahout.cf.taste.impl.recommender.PreferredItemsNeighborhoodCandidateItemsStrategy;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.easymock.EasyMock;
import org.junit.Test;

public final class PreferredItemsNeighborhoodCandidateItemsStrategyTest
extends TasteTestCase {
    @Test
    public void testStrategy() throws TasteException {
        FastIDSet itemIDsFromUser123 = new FastIDSet();
        itemIDsFromUser123.add(1L);
        FastIDSet itemIDsFromUser456 = new FastIDSet();
        itemIDsFromUser456.add(1L);
        itemIDsFromUser456.add(2L);
        ArrayList prefs = Lists.newArrayList();
        prefs.add(new GenericPreference(123L, 1L, 1.0f));
        prefs.add(new GenericPreference(456L, 1L, 1.0f));
        GenericItemPreferenceArray preferencesForItem1 = new GenericItemPreferenceArray((List)prefs);
        DataModel dataModel = (DataModel)EasyMock.createMock(DataModel.class);
        EasyMock.expect((Object)dataModel.getPreferencesForItem(1L)).andReturn((Object)preferencesForItem1);
        EasyMock.expect((Object)dataModel.getItemIDsFromUser(123L)).andReturn((Object)itemIDsFromUser123);
        EasyMock.expect((Object)dataModel.getItemIDsFromUser(456L)).andReturn((Object)itemIDsFromUser456);
        GenericUserPreferenceArray prefArrayOfUser123 = new GenericUserPreferenceArray(Collections.singletonList(new GenericPreference(123L, 1L, 1.0f)));
        PreferredItemsNeighborhoodCandidateItemsStrategy strategy = new PreferredItemsNeighborhoodCandidateItemsStrategy();
        EasyMock.replay((Object[])new Object[]{dataModel});
        FastIDSet candidateItems = strategy.getCandidateItems(123L, (PreferenceArray)prefArrayOfUser123, dataModel, false);
        PreferredItemsNeighborhoodCandidateItemsStrategyTest.assertEquals((long)1L, (long)candidateItems.size());
        PreferredItemsNeighborhoodCandidateItemsStrategyTest.assertTrue((boolean)candidateItems.contains(2L));
        EasyMock.verify((Object[])new Object[]{dataModel});
    }
}

