/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.file;

import java.io.File;
import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.model.file.FileIDMigrator;
import org.junit.Before;
import org.junit.Test;

public final class FileIDMigratorTest
extends TasteTestCase {
    private static final String[] STRING_IDS = new String[]{"dog", "cow"};
    private static final String[] UPDATED_STRING_IDS = new String[]{"dog", "cow", "donkey"};
    private File testFile;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.testFile = this.getTestTempFile("test.txt");
        FileIDMigratorTest.writeLines(this.testFile, STRING_IDS);
    }

    @Test
    public void testLoadFromFile() throws Exception {
        FileIDMigrator migrator = new FileIDMigrator(this.testFile);
        long dogAsLong = migrator.toLongID("dog");
        long cowAsLong = migrator.toLongID("cow");
        long donkeyAsLong = migrator.toLongID("donkey");
        FileIDMigratorTest.assertEquals((Object)"dog", (Object)migrator.toStringID(dogAsLong));
        FileIDMigratorTest.assertEquals((Object)"cow", (Object)migrator.toStringID(cowAsLong));
        FileIDMigratorTest.assertNull((Object)migrator.toStringID(donkeyAsLong));
    }

    @Test
    public void testNoRefreshAfterFileUpdate() throws Exception {
        FileIDMigrator migrator = new FileIDMigrator(this.testFile, 0L);
        long dogAsLong = migrator.toLongID("dog");
        migrator.toStringID(dogAsLong);
        Thread.sleep(2000L);
        FileIDMigratorTest.writeLines(this.testFile, UPDATED_STRING_IDS);
        long cowAsLong = migrator.toLongID("cow");
        long donkeyAsLong = migrator.toLongID("donkey");
        FileIDMigratorTest.assertEquals((Object)"dog", (Object)migrator.toStringID(dogAsLong));
        FileIDMigratorTest.assertEquals((Object)"cow", (Object)migrator.toStringID(cowAsLong));
        FileIDMigratorTest.assertNull((Object)migrator.toStringID(donkeyAsLong));
    }

    @Test
    public void testRefreshAfterFileUpdate() throws Exception {
        FileIDMigrator migrator = new FileIDMigrator(this.testFile, 0L);
        long dogAsLong = migrator.toLongID("dog");
        migrator.toStringID(dogAsLong);
        Thread.sleep(2000L);
        FileIDMigratorTest.writeLines(this.testFile, UPDATED_STRING_IDS);
        migrator.refresh(null);
        long cowAsLong = migrator.toLongID("cow");
        long donkeyAsLong = migrator.toLongID("donkey");
        FileIDMigratorTest.assertEquals((Object)"dog", (Object)migrator.toStringID(dogAsLong));
        FileIDMigratorTest.assertEquals((Object)"cow", (Object)migrator.toStringID(cowAsLong));
        FileIDMigratorTest.assertEquals((Object)"donkey", (Object)migrator.toStringID(donkeyAsLong));
    }
}

