/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.common;

import org.apache.mahout.cf.taste.impl.TasteTestCase;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.junit.Test;

public final class RunningAverageAndStdDevTest
extends TasteTestCase {
    private static final double SMALL_EPSILON = 1.0;

    @Test
    public void testFull() {
        FullRunningAverageAndStdDev average = new FullRunningAverageAndStdDev();
        RunningAverageAndStdDevTest.assertEquals((long)0L, (long)average.getCount());
        RunningAverageAndStdDevTest.assertTrue((boolean)Double.isNaN(average.getAverage()));
        RunningAverageAndStdDevTest.assertTrue((boolean)Double.isNaN(average.getStandardDeviation()));
        average.addDatum(6.0);
        RunningAverageAndStdDevTest.assertEquals((long)1L, (long)average.getCount());
        RunningAverageAndStdDevTest.assertEquals((double)6.0, (double)average.getAverage(), (double)1.0E-6);
        RunningAverageAndStdDevTest.assertTrue((boolean)Double.isNaN(average.getStandardDeviation()));
        average.addDatum(6.0);
        RunningAverageAndStdDevTest.assertEquals((long)2L, (long)average.getCount());
        RunningAverageAndStdDevTest.assertEquals((double)6.0, (double)average.getAverage(), (double)1.0E-6);
        RunningAverageAndStdDevTest.assertEquals((double)0.0, (double)average.getStandardDeviation(), (double)1.0E-6);
        average.removeDatum(6.0);
        RunningAverageAndStdDevTest.assertEquals((long)1L, (long)average.getCount());
        RunningAverageAndStdDevTest.assertEquals((double)6.0, (double)average.getAverage(), (double)1.0E-6);
        RunningAverageAndStdDevTest.assertTrue((boolean)Double.isNaN(average.getStandardDeviation()));
        average.addDatum(-4.0);
        RunningAverageAndStdDevTest.assertEquals((long)2L, (long)average.getCount());
        RunningAverageAndStdDevTest.assertEquals((double)1.0, (double)average.getAverage(), (double)1.0E-6);
        RunningAverageAndStdDevTest.assertEquals((double)7.0710678118654755, (double)average.getStandardDeviation(), (double)1.0E-6);
        average.removeDatum(4.0);
        RunningAverageAndStdDevTest.assertEquals((long)1L, (long)average.getCount());
        RunningAverageAndStdDevTest.assertEquals((double)-2.0, (double)average.getAverage(), (double)1.0E-6);
        RunningAverageAndStdDevTest.assertTrue((boolean)Double.isNaN(average.getStandardDeviation()));
    }

    @Test
    public void testFullBig() {
        FullRunningAverageAndStdDev average = new FullRunningAverageAndStdDev();
        RandomWrapper r = RandomUtils.getRandom();
        for (int i = 0; i < 100000; ++i) {
            average.addDatum(r.nextDouble() * 1000.0);
        }
        RunningAverageAndStdDevTest.assertEquals((double)500.0, (double)average.getAverage(), (double)1.0);
        RunningAverageAndStdDevTest.assertEquals((double)(1000.0 / Math.sqrt(12.0)), (double)average.getStandardDeviation(), (double)1.0);
    }

    @Test
    public void testStddev() {
        FullRunningAverageAndStdDev runningAverage = new FullRunningAverageAndStdDev();
        RunningAverageAndStdDevTest.assertEquals((long)0L, (long)runningAverage.getCount());
        RunningAverageAndStdDevTest.assertTrue((boolean)Double.isNaN(runningAverage.getAverage()));
        runningAverage.addDatum(1.0);
        RunningAverageAndStdDevTest.assertEquals((long)1L, (long)runningAverage.getCount());
        RunningAverageAndStdDevTest.assertEquals((double)1.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        RunningAverageAndStdDevTest.assertTrue((boolean)Double.isNaN(runningAverage.getStandardDeviation()));
        runningAverage.addDatum(1.0);
        RunningAverageAndStdDevTest.assertEquals((long)2L, (long)runningAverage.getCount());
        RunningAverageAndStdDevTest.assertEquals((double)1.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        RunningAverageAndStdDevTest.assertEquals((double)0.0, (double)runningAverage.getStandardDeviation(), (double)1.0E-6);
        runningAverage.addDatum(7.0);
        RunningAverageAndStdDevTest.assertEquals((long)3L, (long)runningAverage.getCount());
        RunningAverageAndStdDevTest.assertEquals((double)3.0, (double)runningAverage.getAverage(), (double)1.0E-6);
        RunningAverageAndStdDevTest.assertEquals((double)3.464101552963257, (double)runningAverage.getStandardDeviation(), (double)1.0E-6);
        runningAverage.addDatum(5.0);
        RunningAverageAndStdDevTest.assertEquals((long)4L, (long)runningAverage.getCount());
        RunningAverageAndStdDevTest.assertEquals((double)3.5, (double)runningAverage.getAverage(), (double)1.0E-6);
        RunningAverageAndStdDevTest.assertEquals((double)3.0, (double)runningAverage.getStandardDeviation(), (double)1.0E-6);
    }
}

