/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.topdown.postprocessor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirValueIterator;

public final class ClusterCountReader {
    private ClusterCountReader() {
    }

    public static int getNumberOfClusters(Path clusterOutputPath, Configuration conf) throws IOException {
        FileSystem fileSystem = clusterOutputPath.getFileSystem(conf);
        FileStatus[] clusterFiles = fileSystem.listStatus(clusterOutputPath, PathFilters.finalPartFilter());
        int numberOfClusters = 0;
        SequenceFileDirValueIterator it = new SequenceFileDirValueIterator(clusterFiles[0].getPath(), PathType.LIST, PathFilters.partFilter(), null, true, conf);
        while (it.hasNext()) {
            it.next();
            ++numberOfClusters;
        }
        return numberOfClusters;
    }

    public static Map<Integer, Integer> getClusterIDs(Path clusterOutputPath, Configuration conf, boolean keyIsClusterId) throws IOException {
        HashMap<Integer, Integer> clusterIds = new HashMap<Integer, Integer>();
        FileSystem fileSystem = clusterOutputPath.getFileSystem(conf);
        FileStatus[] clusterFiles = fileSystem.listStatus(clusterOutputPath, PathFilters.finalPartFilter());
        SequenceFileDirValueIterator it = new SequenceFileDirValueIterator(clusterFiles[0].getPath(), PathType.LIST, PathFilters.partFilter(), null, true, conf);
        int i = 0;
        while (it.hasNext()) {
            Integer value;
            Integer key;
            if (keyIsClusterId) {
                key = ((ClusterWritable)it.next()).getValue().getId();
                value = i;
            } else {
                key = i;
                value = ((ClusterWritable)it.next()).getValue().getId();
            }
            clusterIds.put(key, value);
            ++i;
        }
        return clusterIds;
    }
}

