/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.hadoop.als;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.mahout.cf.taste.hadoop.MutableRecommendedItem;
import org.apache.mahout.cf.taste.hadoop.RecommendedItemsWritable;
import org.apache.mahout.cf.taste.hadoop.TasteHadoopUtils;
import org.apache.mahout.cf.taste.hadoop.TopItemsQueue;
import org.apache.mahout.cf.taste.hadoop.als.ALS;
import org.apache.mahout.cf.taste.hadoop.als.ParallelALSFactorizationJob;
import org.apache.mahout.cf.taste.hadoop.als.RecommenderJob;
import org.apache.mahout.cf.taste.hadoop.als.SharingMapper;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.common.Pair;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.function.IntObjectProcedure;
import org.apache.mahout.math.map.OpenIntLongHashMap;
import org.apache.mahout.math.map.OpenIntObjectHashMap;
import org.apache.mahout.math.set.OpenIntHashSet;

public class PredictionMapper
extends SharingMapper<IntWritable, VectorWritable, LongWritable, RecommendedItemsWritable, Pair<OpenIntObjectHashMap<Vector>, OpenIntObjectHashMap<Vector>>> {
    private int recommendationsPerUser;
    private float maxRating;
    private boolean usesLongIDs;
    private OpenIntLongHashMap userIDIndex;
    private OpenIntLongHashMap itemIDIndex;
    private final LongWritable userIDWritable = new LongWritable();
    private final RecommendedItemsWritable recommendations = new RecommendedItemsWritable();

    @Override
    Pair<OpenIntObjectHashMap<Vector>, OpenIntObjectHashMap<Vector>> createSharedInstance(Mapper.Context ctx) {
        Configuration conf = ctx.getConfiguration();
        Path pathToU = new Path(conf.get(RecommenderJob.USER_FEATURES_PATH));
        Path pathToM = new Path(conf.get(RecommenderJob.ITEM_FEATURES_PATH));
        OpenIntObjectHashMap<Vector> U = ALS.readMatrixByRows(pathToU, conf);
        OpenIntObjectHashMap<Vector> M = ALS.readMatrixByRows(pathToM, conf);
        return new Pair<OpenIntObjectHashMap<Vector>, OpenIntObjectHashMap<Vector>>(U, M);
    }

    protected void setup(Mapper.Context ctx) throws IOException, InterruptedException {
        Configuration conf = ctx.getConfiguration();
        this.recommendationsPerUser = conf.getInt(RecommenderJob.NUM_RECOMMENDATIONS, 10);
        this.maxRating = Float.parseFloat(conf.get(RecommenderJob.MAX_RATING));
        this.usesLongIDs = conf.getBoolean(ParallelALSFactorizationJob.USES_LONG_IDS, false);
        if (this.usesLongIDs) {
            this.userIDIndex = TasteHadoopUtils.readIDIndexMap(conf.get(RecommenderJob.USER_INDEX_PATH), conf);
            this.itemIDIndex = TasteHadoopUtils.readIDIndexMap(conf.get(RecommenderJob.ITEM_INDEX_PATH), conf);
        }
    }

    protected void map(IntWritable userIndexWritable, VectorWritable ratingsWritable, Mapper.Context ctx) throws IOException, InterruptedException {
        Pair uAndM = (Pair)this.getSharedInstance();
        OpenIntObjectHashMap U = (OpenIntObjectHashMap)uAndM.getFirst();
        OpenIntObjectHashMap M = (OpenIntObjectHashMap)uAndM.getSecond();
        Vector ratings = ratingsWritable.get();
        int userIndex = userIndexWritable.get();
        final OpenIntHashSet alreadyRatedItems = new OpenIntHashSet(ratings.getNumNondefaultElements());
        for (Vector.Element e : ratings.nonZeroes()) {
            alreadyRatedItems.add(e.index());
        }
        final TopItemsQueue topItemsQueue = new TopItemsQueue(this.recommendationsPerUser);
        final Vector userFeatures = (Vector)U.get(userIndex);
        M.forEachPair((IntObjectProcedure)new IntObjectProcedure<Vector>(){

            public boolean apply(int itemID, Vector itemFeatures) {
                MutableRecommendedItem top;
                double predictedRating;
                if (!alreadyRatedItems.contains(itemID) && (predictedRating = userFeatures.dot(itemFeatures)) > (double)(top = (MutableRecommendedItem)topItemsQueue.top()).getValue()) {
                    top.set(itemID, (float)predictedRating);
                    topItemsQueue.updateTop();
                }
                return true;
            }
        });
        List<RecommendedItem> recommendedItems = topItemsQueue.getTopItems();
        if (!recommendedItems.isEmpty()) {
            for (RecommendedItem topItem : recommendedItems) {
                ((MutableRecommendedItem)topItem).capToMaxValue(this.maxRating);
            }
            if (this.usesLongIDs) {
                long userID = this.userIDIndex.get(userIndex);
                this.userIDWritable.set(userID);
                for (RecommendedItem topItem : recommendedItems) {
                    long itemID = this.itemIDIndex.get((int)topItem.getItemID());
                    ((MutableRecommendedItem)topItem).setItemID(itemID);
                }
            } else {
                this.userIDWritable.set((long)userIndex);
            }
            this.recommendations.set(recommendedItems);
            ctx.write((Object)this.userIDWritable, (Object)this.recommendations);
        }
    }
}

