/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.encoders;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.util.Version;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.vectorizer.encoders.FeatureVectorEncoder;
import org.apache.mahout.vectorizer.encoders.LuceneTextValueEncoder;
import org.apache.mahout.vectorizer.encoders.StaticWordValueEncoder;
import org.apache.mahout.vectorizer.encoders.TextValueEncoder;
import org.junit.Test;

public final class TextValueEncoderTest
extends MahoutTestCase {
    @Test
    public void testAddToVector() {
        TextValueEncoder enc = new TextValueEncoder("text");
        DenseVector v1 = new DenseVector(200);
        enc.addToVector("test1 and more", (Vector)v1);
        enc.flush(1.0, (Vector)v1);
        TextValueEncoderTest.assertEquals((double)6.0, (double)v1.norm(1.0), (double)0.0);
        TextValueEncoderTest.assertEquals((double)1.0, (double)v1.maxValue(), (double)0.0);
        StaticWordValueEncoder w = new StaticWordValueEncoder("text");
        w.setDictionary((Map)ImmutableMap.of((Object)"word1", (Object)3.0, (Object)"word2", (Object)1.5));
        enc.setWordEncoder((FeatureVectorEncoder)w);
        DenseVector v2 = new DenseVector(200);
        enc.addToVector("test1 and more", (Vector)v2);
        enc.flush(1.0, (Vector)v2);
        DenseVector v3 = new DenseVector(200);
        w.addToVector("test1", (Vector)v3);
        w.addToVector("and", (Vector)v3);
        w.addToVector("more", (Vector)v3);
        TextValueEncoderTest.assertEquals((double)0.0, (double)v3.minus((Vector)v2).norm(1.0), (double)0.0);
        TextValueEncoderTest.assertEquals((double)v3.zSum(), (double)v3.dot((Vector)v1), (double)0.0);
    }

    @Test
    public void testAsString() {
        Locale.setDefault(Locale.ENGLISH);
        TextValueEncoder enc = new TextValueEncoder("text");
        TextValueEncoderTest.assertEquals((Object)"[text:test1:1.0000, text:and:1.0000, text:more:1.0000]", (Object)enc.asString("test1 and more"));
    }

    @Test
    public void testLuceneEncoding() throws Exception {
        LuceneTextValueEncoder enc = new LuceneTextValueEncoder("text");
        enc.setAnalyzer((Analyzer)new WhitespaceAnalyzer(Version.LUCENE_46));
        DenseVector v1 = new DenseVector(200);
        enc.addToVector("test1 and more", (Vector)v1);
        enc.flush(1.0, (Vector)v1);
        TextValueEncoderTest.assertEquals((double)6.0, (double)v1.norm(1.0), (double)0.0);
        TextValueEncoderTest.assertEquals((double)1.0, (double)v1.maxValue(), (double)0.0);
        v1 = new DenseVector(200);
        enc.addToVector("", (Vector)v1);
        enc.flush(1.0, (Vector)v1);
        TextValueEncoderTest.assertEquals((double)0.0, (double)v1.norm(1.0), (double)0.0);
        TextValueEncoderTest.assertEquals((double)0.0, (double)v1.maxValue(), (double)0.0);
        v1 = new DenseVector(200);
        StringBuilder builder = new StringBuilder(5000);
        for (int i = 0; i < 1000; ++i) {
            builder.append("token_").append(i).append(' ');
        }
        enc.addToVector(builder.toString(), (Vector)v1);
        enc.flush(1.0, (Vector)v1);
        TextValueEncoderTest.assertEquals((double)2000.0, (double)v1.norm(1.0), (double)0.0);
        TextValueEncoderTest.assertEquals((double)19.0, (double)v1.maxValue(), (double)0.0);
    }
}

