/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer;

import java.util.Random;
import org.apache.mahout.common.RandomUtils;

public class RandomDocumentGenerator {
    private static final int AVG_DOCUMENT_LENGTH = 20;
    private static final int AVG_SENTENCE_LENGTH = 8;
    private static final int AVG_WORD_LENGTH = 6;
    private static final String CHARSET = "abcdef";
    private static final String DELIM = " .,?;:!\t\n\r";
    private static final String ERRORSET = "`1234567890-=~@#$%^&*()_+[]{}'\"/<>|\\";
    private final Random random = RandomUtils.getRandom();

    private char getRandomDelimiter() {
        return DELIM.charAt(this.random.nextInt(DELIM.length()));
    }

    public String getRandomDocument() {
        int length = 10 + this.random.nextInt(20);
        StringBuilder sb = new StringBuilder(length * 8 * 6);
        for (int i = 0; i < length; ++i) {
            sb.append(this.getRandomSentence());
        }
        return sb.toString();
    }

    public String getRandomSentence() {
        int length = 4 + this.random.nextInt(8);
        StringBuilder sb = new StringBuilder(length * 6);
        for (int i = 0; i < length; ++i) {
            sb.append(this.getRandomString()).append(' ');
        }
        sb.append(this.getRandomDelimiter());
        return sb.toString();
    }

    public String getRandomString() {
        int length = 3 + this.random.nextInt(6);
        StringBuilder sb = new StringBuilder(length);
        for (int i = 0; i < length; ++i) {
            sb.append(CHARSET.charAt(this.random.nextInt(CHARSET.length())));
        }
        if (this.random.nextInt(10) == 0) {
            sb.append(ERRORSET.charAt(this.random.nextInt(ERRORSET.length())));
        }
        return sb.toString();
    }
}

