/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.ssvd;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.DiagonalMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixWritable;
import org.apache.mahout.math.RandomTrinaryMatrix;
import org.apache.mahout.math.SingularValueDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.ssvd.SequentialBigSvd;
import org.apache.mahout.math.ssvd.SequentialOutOfCoreSvd;
import org.junit.Before;
import org.junit.Test;

public final class SequentialOutOfCoreSvdTest
extends MahoutTestCase {
    private File tmpDir;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.tmpDir = this.getTestTempDir("matrix");
    }

    @Test
    public void testSingularValues() throws IOException {
        Matrix A = SequentialOutOfCoreSvdTest.lowRankMatrix(this.tmpDir, "A", 200, 970, 1020);
        List partsOfA = Arrays.asList(this.tmpDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String fileName) {
                return fileName.matches("A-.*");
            }
        }));
        partsOfA = Lists.reverse(partsOfA);
        SequentialOutOfCoreSvd s = new SequentialOutOfCoreSvd((Iterable)partsOfA, this.tmpDir, 100, 210);
        SequentialBigSvd svd = new SequentialBigSvd(A, 100);
        Vector reference = new DenseVector(svd.getSingularValues()).viewPart(0, 6);
        Vector actual = s.getSingularValues().viewPart(0, 6);
        SequentialOutOfCoreSvdTest.assertEquals((double)0.0, (double)reference.minus(actual).maxValue(), (double)1.0E-9);
        s.computeU((Iterable)partsOfA, this.tmpDir);
        Matrix u = SequentialOutOfCoreSvdTest.readBlockMatrix(Arrays.asList(this.tmpDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String fileName) {
                return fileName.matches("U-.*");
            }
        })));
        s.computeV(this.tmpDir, A.columnSize());
        Matrix v = SequentialOutOfCoreSvdTest.readBlockMatrix(Arrays.asList(this.tmpDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String fileName) {
                return fileName.matches("V-.*");
            }
        })));
        SequentialOutOfCoreSvdTest.assertEquals((double)0.0, (double)A.minus(u.times((Matrix)new DiagonalMatrix(s.getSingularValues())).times(v.transpose())).aggregate(Functions.PLUS, Functions.ABS), (double)1.0E-7);
    }

    private static Matrix readBlockMatrix(List<File> files) throws IOException {
        Collections.sort(files);
        int nrows = -1;
        int ncols = -1;
        Matrix r = null;
        MatrixWritable m = new MatrixWritable();
        int row = 0;
        for (File file : files) {
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            m.readFields((DataInput)in);
            in.close();
            if (nrows == -1) {
                nrows = m.get().rowSize() * files.size();
                ncols = m.get().columnSize();
                r = new DenseMatrix(nrows, ncols);
            }
            r.viewPart(row, m.get().rowSize(), 0, r.columnSize()).assign(m.get());
            row += m.get().rowSize();
        }
        if (row != nrows && r != null) {
            r = r.viewPart(0, row, 0, ncols);
        }
        return r;
    }

    @Test
    public void testLeftVectors() throws IOException {
        Matrix A = SequentialOutOfCoreSvdTest.lowRankMatrixInMemory(20, 20);
        SequentialBigSvd s = new SequentialBigSvd(A, 6);
        SingularValueDecomposition svd = new SingularValueDecomposition(A);
        Matrix u1 = svd.getU().viewPart(0, 20, 0, 3).assign(Functions.ABS);
        Matrix u2 = s.getU().viewPart(0, 20, 0, 3).assign(Functions.ABS);
        SequentialOutOfCoreSvdTest.assertEquals(u1, u2);
    }

    private static Matrix lowRankMatrixInMemory(int rows, int columns) throws IOException {
        return SequentialOutOfCoreSvdTest.lowRankMatrix(null, null, 0, rows, columns);
    }

    private static void assertEquals(Matrix u1, Matrix u2) {
        SequentialOutOfCoreSvdTest.assertEquals((double)0.0, (double)u1.minus(u2).aggregate(Functions.MAX, Functions.ABS), (double)1.0E-10);
    }

    @Test
    public void testRightVectors() throws IOException {
        Matrix A = SequentialOutOfCoreSvdTest.lowRankMatrixInMemory(20, 20);
        SequentialBigSvd s = new SequentialBigSvd(A, 6);
        SingularValueDecomposition svd = new SingularValueDecomposition(A);
        Matrix v1 = svd.getV().viewPart(0, 20, 0, 3).assign(Functions.ABS);
        Matrix v2 = s.getV().viewPart(0, 20, 0, 3).assign(Functions.ABS);
        SequentialOutOfCoreSvdTest.assertEquals(v1, v2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Matrix lowRankMatrix(File tmpDir, String aBase, int rowsPerSlice, int rows, int columns) throws IOException {
        int rank = 10;
        RandomTrinaryMatrix u = new RandomTrinaryMatrix(1, rows, rank, false);
        DenseMatrix d = new DenseMatrix(rank, rank);
        d.set(0, 0, 5.0);
        d.set(1, 1, 3.0);
        d.set(2, 2, 1.0);
        d.set(3, 3, 0.5);
        RandomTrinaryMatrix v = new RandomTrinaryMatrix(2, columns, rank, false);
        Matrix a = u.times((Matrix)d).times(v.transpose());
        if (tmpDir != null) {
            for (int i = 0; i < a.rowSize(); i += rowsPerSlice) {
                MatrixWritable m = new MatrixWritable(a.viewPart(i, Math.min(a.rowSize() - i, rowsPerSlice), 0, a.columnSize()));
                try (DataOutputStream out = new DataOutputStream(new FileOutputStream(new File(tmpDir, String.format("%s-%09d", aBase, i))));){
                    m.write((DataOutput)out);
                    continue;
                }
            }
        }
        return a;
    }
}

