/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.ep;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.ep.EvolutionaryProcess;
import org.apache.mahout.ep.Payload;
import org.apache.mahout.ep.State;
import org.junit.Test;

public final class EvolutionaryProcessTest
extends MahoutTestCase {
    @Test
    public void testConverges() throws Exception {
        State s0 = new State(new double[5], 1.0);
        s0.setPayload((Payload)new Foo());
        EvolutionaryProcess ep = new EvolutionaryProcess(10, 100, s0);
        State best = null;
        for (int i = 0; i < 20; ++i) {
            best = ep.parallelDo((EvolutionaryProcess.Function)new EvolutionaryProcess.Function<Payload<Double>>(){

                public double apply(Payload<Double> payload, double[] params) {
                    int i = 1;
                    double sum = 0.0;
                    for (double x : params) {
                        sum += (double)i * (x - (double)i) * (x - (double)i);
                        ++i;
                    }
                    return -sum;
                }
            });
            ep.mutatePopulation(3);
            System.out.printf("%10.3f %.3f\n", best.getValue(), best.getOmni());
        }
        ep.close();
        EvolutionaryProcessTest.assertNotNull(best);
        EvolutionaryProcessTest.assertEquals((double)0.0, (double)best.getValue(), (double)0.02);
    }

    private static class Foo
    implements Payload<Double> {
        private Foo() {
        }

        public Foo copy() {
            return this;
        }

        public void update(double[] params) {
        }

        public void write(DataOutput dataOutput) throws IOException {
        }

        public void readFields(DataInput dataInput) throws IOException {
        }
    }
}

