/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.streaming.tools;

import com.google.common.collect.Iterables;
import com.google.common.io.Closeables;
import java.io.Closeable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Writable;
import org.apache.mahout.clustering.streaming.tools.ResplitSequenceFiles;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.iterator.sequencefile.PathFilters;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileIterable;
import org.junit.Test;

public class ResplitSequenceFilesTest
extends MahoutTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitting() throws Exception {
        FileStatus[] statuses;
        Path inputFile = new Path(this.getTestTempDirPath("input"), "test.seq");
        Path output = this.getTestTempDirPath("output");
        Configuration conf = new Configuration();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)conf);
        SequenceFile.Writer writer = null;
        try {
            writer = SequenceFile.createWriter((FileSystem)fs, (Configuration)conf, (Path)inputFile, IntWritable.class, IntWritable.class);
            writer.append((Writable)new IntWritable(1), (Writable)new IntWritable(1));
            writer.append((Writable)new IntWritable(2), (Writable)new IntWritable(2));
            writer.append((Writable)new IntWritable(3), (Writable)new IntWritable(3));
            writer.append((Writable)new IntWritable(4), (Writable)new IntWritable(4));
            writer.append((Writable)new IntWritable(5), (Writable)new IntWritable(5));
            writer.append((Writable)new IntWritable(6), (Writable)new IntWritable(6));
            writer.append((Writable)new IntWritable(7), (Writable)new IntWritable(7));
            writer.append((Writable)new IntWritable(8), (Writable)new IntWritable(8));
        }
        catch (Throwable throwable) {
            Closeables.close(writer, (boolean)false);
            throw throwable;
        }
        Closeables.close((Closeable)writer, (boolean)false);
        String splitPattern = "split";
        int numSplits = 4;
        ResplitSequenceFiles.main((String[])new String[]{"--input", inputFile.toString(), "--output", output.toString() + "/" + splitPattern, "--numSplits", String.valueOf(numSplits)});
        for (FileStatus status : statuses = HadoopUtil.getFileStatus((Path)output, (PathType)PathType.LIST, (PathFilter)PathFilters.logsCRCFilter(), null, (Configuration)conf)) {
            String name = status.getPath().getName();
            ResplitSequenceFilesTest.assertTrue((boolean)name.startsWith(splitPattern));
            ResplitSequenceFilesTest.assertEquals((long)2L, (long)this.numEntries(status, conf));
        }
        ResplitSequenceFilesTest.assertEquals((long)numSplits, (long)statuses.length);
    }

    private int numEntries(FileStatus status, Configuration conf) {
        return Iterables.size((Iterable)new SequenceFileIterable(status.getPath(), conf));
    }
}

