/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.clustering.spectral.kmeans;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.ClusteringTestUtils;
import org.apache.mahout.clustering.iterator.ClusterWritable;
import org.apache.mahout.clustering.spectral.kmeans.EigenSeedGenerator;
import org.apache.mahout.common.MahoutTestCase;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.common.distance.ManhattanDistanceMeasure;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterable;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.junit.Before;
import org.junit.Test;

public final class TestEigenSeedGenerator
extends MahoutTestCase {
    private static final double[][] RAW = new double[][]{{1.0, 0.0, 0.0}, {1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {0.0, 0.0, 1.0}};
    private FileSystem fs;

    private static List<VectorWritable> getPoints() {
        ArrayList points = Lists.newArrayList();
        for (double[] fr : RAW) {
            RandomAccessSparseVector vec = new RandomAccessSparseVector(fr.length);
            vec.assign(fr);
            points.add(new VectorWritable((Vector)vec));
        }
        return points;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        Configuration conf = this.getConfiguration();
        this.fs = FileSystem.get((Configuration)conf);
    }

    @Test
    public void testEigenSeedGenerator() throws Exception {
        List<VectorWritable> points = TestEigenSeedGenerator.getPoints();
        Job job = new Job();
        Configuration conf = job.getConfiguration();
        job.setMapOutputValueClass(VectorWritable.class);
        Path input = this.getTestTempFilePath("eigen-input");
        Path output = this.getTestTempDirPath("eigen-output");
        ClusteringTestUtils.writePointsToFile(points, input, this.fs, conf);
        EigenSeedGenerator.buildFromEigens((Configuration)conf, (Path)input, (Path)output, (int)3, (DistanceMeasure)new ManhattanDistanceMeasure());
        int clusterCount = 0;
        HashSet<Integer> set = new HashSet<Integer>();
        Vector[] v = new Vector[3];
        for (ClusterWritable clusterWritable : new SequenceFileValueIterable(new Path(output, "part-eigenSeed"), true, conf)) {
            Cluster cluster = clusterWritable.getValue();
            int id = cluster.getId();
            TestEigenSeedGenerator.assertTrue((boolean)set.add(id));
            v[id] = cluster.getCenter();
            ++clusterCount;
        }
        TestEigenSeedGenerator.assertEquals((long)3L, (long)clusterCount);
        TestEigenSeedGenerator.assertEquals((double)0.0, (double)v[0].dot(v[1]), (double)1.0E-10);
        TestEigenSeedGenerator.assertEquals((double)0.0, (double)v[1].dot(v[2]), (double)1.0E-10);
        TestEigenSeedGenerator.assertEquals((double)0.0, (double)v[0].dot(v[2]), (double)1.0E-10);
    }
}

